/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.exception.metadata.view.UnsupportedViewException;
import org.apache.iotdb.db.metadata.view.ViewPathType;
import org.apache.iotdb.db.metadata.view.ViewPaths;
import org.apache.iotdb.db.mpp.plan.analyze.SelectIntoUtils;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.IntoComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.IntoItem;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.tsfile.utils.Pair;

public class CreateLogicalViewStatement
extends Statement {
    private ViewPaths targetPaths;
    private IntoItem batchGenerationItem;
    private ViewPaths sourcePaths;
    private QueryStatement queryStatement;
    private ViewExpression viewExpression;

    public CreateLogicalViewStatement() {
        this.statementType = StatementType.CREATE_LOGICAL_VIEW;
        this.sourcePaths = new ViewPaths();
        this.targetPaths = new ViewPaths();
    }

    public List<PartialPath> getPaths() {
        return this.getTargetPathList();
    }

    public ViewPaths getTargetPaths() {
        return this.targetPaths;
    }

    public ViewPaths getSourcePaths() {
        return this.sourcePaths;
    }

    public List<PartialPath> getTargetPathList() {
        return this.targetPaths.fullPathList;
    }

    public List<Expression> getSourceExpressionList() {
        this.sourcePaths.generateExpressionsIfNecessary();
        return this.sourcePaths.expressionsList;
    }

    public QueryStatement getQueryStatement() {
        return this.queryStatement;
    }

    public ViewExpression getViewExpression() {
        return this.viewExpression;
    }

    public void setSourcePaths(ViewPaths sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void setSourceFullPaths(List<PartialPath> paths) {
        this.sourcePaths.setViewPathType(ViewPathType.FULL_PATH_LIST);
        this.sourcePaths.setFullPathList(paths);
    }

    public void setSourcePathsGroup(PartialPath prefixPath, List<PartialPath> suffixPaths) {
        this.sourcePaths.setViewPathType(ViewPathType.PATHS_GROUP);
        this.sourcePaths.setPrefixOfPathsGroup(prefixPath);
        this.sourcePaths.setSuffixOfPathsGroup(suffixPaths);
        this.sourcePaths.generateFullPathsFromPathsGroup();
    }

    public void setSourceQueryStatement(QueryStatement queryStatement) {
        this.sourcePaths.setViewPathType(ViewPathType.QUERY_STATEMENT);
        this.queryStatement = queryStatement;
    }

    public void setQueryStatement(QueryStatement queryStatement) {
        this.queryStatement = queryStatement;
    }

    public void setSourceExpressions(List<Expression> expressionList) throws UnsupportedViewException {
        Pair<Boolean, UnsupportedViewException> checkResult = ViewPaths.checkExpressionList(expressionList);
        if (!((Boolean)checkResult.left).booleanValue()) {
            throw (UnsupportedViewException)((Object)checkResult.right);
        }
        this.sourcePaths.setExpressionsList(expressionList);
    }

    public void setTargetPaths(ViewPaths targetPaths) {
        this.targetPaths = targetPaths;
    }

    public void setTargetFullPaths(List<PartialPath> paths) {
        this.targetPaths.setViewPathType(ViewPathType.FULL_PATH_LIST);
        this.targetPaths.setFullPathList(paths);
    }

    public void setTargetPathsGroup(PartialPath prefixPath, List<PartialPath> suffixPaths) {
        this.targetPaths.setViewPathType(ViewPathType.PATHS_GROUP);
        this.targetPaths.setPrefixOfPathsGroup(prefixPath);
        this.targetPaths.setSuffixOfPathsGroup(suffixPaths);
        this.targetPaths.generateFullPathsFromPathsGroup();
    }

    public void setViewExpression(ViewExpression viewExpression) {
        this.viewExpression = viewExpression;
    }

    public void setTargetIntoItem(IntoItem intoItem) {
        this.targetPaths.setViewPathType(ViewPathType.BATCH_GENERATION);
        this.batchGenerationItem = intoItem;
    }

    public void parseIntoItemIfNecessary() {
        if (this.batchGenerationItem != null) {
            List<Expression> sourceExpressionList = this.getSourceExpressionList();
            IntoComponent intoComponent = new IntoComponent(Collections.singletonList(this.batchGenerationItem));
            intoComponent.validate(sourceExpressionList);
            IntoComponent.IntoPathIterator intoPathIterator = intoComponent.getIntoPathIterator();
            ArrayList<PartialPath> targetPathsList = new ArrayList<PartialPath>();
            for (Expression sourceColumn : sourceExpressionList) {
                PartialPath deviceTemplate = intoPathIterator.getDeviceTemplate();
                String measurementTemplate = intoPathIterator.getMeasurementTemplate();
                if (sourceColumn instanceof TimeSeriesOperand) {
                    PartialPath sourcePath = ((TimeSeriesOperand)sourceColumn).getPath();
                    targetPathsList.add(SelectIntoUtils.constructTargetPath(sourcePath, deviceTemplate, measurementTemplate));
                    continue;
                }
                throw new RuntimeException((Throwable)((Object)new UnsupportedViewException("Cannot create views using data sources with calculated expressions while using into item.")));
            }
            this.targetPaths.setFullPathList(targetPathsList);
        }
    }

    public Pair<Boolean, String> checkTargetPaths() {
        for (PartialPath thisPath : this.getTargetPathList()) {
            if (thisPath.getNodeLength() >= 3) continue;
            return new Pair((Object)false, (Object)thisPath.getFullPath());
        }
        return new Pair((Object)true, null);
    }

    public Pair<Boolean, String> checkSourcePathsIfNotUsingQueryStatement() {
        if (this.sourcePaths.viewPathType == ViewPathType.PATHS_GROUP || this.sourcePaths.viewPathType == ViewPathType.FULL_PATH_LIST) {
            for (PartialPath thisPath : this.sourcePaths.fullPathList) {
                if (thisPath.getNodeLength() >= 3) continue;
                return new Pair((Object)false, (Object)thisPath.getFullPath());
            }
        }
        return new Pair((Object)true, null);
    }

    public Pair<Boolean, String> checkAllPaths() {
        Pair<Boolean, String> result = this.checkTargetPaths();
        if (!((Boolean)result.left).booleanValue()) {
            return result;
        }
        result = this.checkSourcePathsIfNotUsingQueryStatement();
        if (!((Boolean)result.left).booleanValue()) {
            return result;
        }
        return new Pair((Object)true, null);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateLogicalView(this, context);
    }
}

