/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.column;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.BinaryType;
import org.apache.iotdb.tsfile.read.common.type.BooleanType;
import org.apache.iotdb.tsfile.read.common.type.DoubleType;
import org.apache.iotdb.tsfile.read.common.type.FloatType;
import org.apache.iotdb.tsfile.read.common.type.IntType;
import org.apache.iotdb.tsfile.read.common.type.LongType;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.utils.Pair;

public class CaseWhenThenColumnTransformer
extends ColumnTransformer {
    List<Pair<ColumnTransformer, ColumnTransformer>> whenThenTransformers;
    ColumnTransformer elseTransformer;

    public CaseWhenThenColumnTransformer(Type returnType, List<ColumnTransformer> whenTransformers, List<ColumnTransformer> thenTransformers, ColumnTransformer elseTransformer) {
        super(returnType);
        Validate.isTrue((whenTransformers.size() == thenTransformers.size() ? 1 : 0) != 0, (String)"the size between whenTransformers and thenTransformers needs to be same", (Object[])new Object[0]);
        this.whenThenTransformers = new ArrayList<Pair<ColumnTransformer, ColumnTransformer>>();
        for (int i = 0; i < whenTransformers.size(); ++i) {
            this.whenThenTransformers.add((Pair<ColumnTransformer, ColumnTransformer>)new Pair((Object)whenTransformers.get(i), (Object)thenTransformers.get(i)));
        }
        this.elseTransformer = elseTransformer;
    }

    public List<Pair<ColumnTransformer, ColumnTransformer>> getWhenThenColumnTransformers() {
        return this.whenThenTransformers;
    }

    public ColumnTransformer getElseTransformer() {
        return this.elseTransformer;
    }

    private void writeToColumnBuilder(ColumnTransformer childTransformer, Column column, int index, ColumnBuilder builder) {
        if (this.returnType instanceof BooleanType) {
            builder.writeBoolean(childTransformer.getType().getBoolean(column, index));
        } else if (this.returnType instanceof IntType) {
            builder.writeInt(childTransformer.getType().getInt(column, index));
        } else if (this.returnType instanceof LongType) {
            builder.writeLong(childTransformer.getType().getLong(column, index));
        } else if (this.returnType instanceof FloatType) {
            builder.writeFloat(childTransformer.getType().getFloat(column, index));
        } else if (this.returnType instanceof DoubleType) {
            builder.writeDouble(childTransformer.getType().getDouble(column, index));
        } else if (this.returnType instanceof BinaryType) {
            builder.writeBinary(childTransformer.getType().getBinary(column, index));
        } else {
            throw new UnsupportedOperationException("Unsupported Type");
        }
    }

    @Override
    protected void evaluate() {
        ArrayList<Column> whenColumnList = new ArrayList<Column>();
        ArrayList<Column> thenColumnList = new ArrayList<Column>();
        for (Pair<ColumnTransformer, ColumnTransformer> pair : this.whenThenTransformers) {
            ((ColumnTransformer)pair.left).tryEvaluate();
            ((ColumnTransformer)pair.right).tryEvaluate();
        }
        this.elseTransformer.tryEvaluate();
        int positionCount = ((ColumnTransformer)this.whenThenTransformers.get((int)0).left).getColumnCachePositionCount();
        for (Pair<ColumnTransformer, ColumnTransformer> pair : this.whenThenTransformers) {
            whenColumnList.add(((ColumnTransformer)pair.left).getColumn());
            thenColumnList.add(((ColumnTransformer)pair.right).getColumn());
        }
        ColumnBuilder columnBuilder = this.returnType.createColumnBuilder(positionCount);
        Column column = this.elseTransformer.getColumn();
        for (int i = 0; i < positionCount; ++i) {
            boolean hasValue = false;
            for (int j = 0; j < this.whenThenTransformers.size(); ++j) {
                Column whenColumn = (Column)whenColumnList.get(j);
                Column thenColumn = (Column)thenColumnList.get(j);
                if (whenColumn.isNull(i) || !whenColumn.getBoolean(i)) continue;
                if (thenColumn.isNull(i)) {
                    columnBuilder.appendNull();
                } else {
                    this.writeToColumnBuilder((ColumnTransformer)this.whenThenTransformers.get((int)j).right, thenColumn, i, columnBuilder);
                }
                hasValue = true;
                break;
            }
            if (hasValue) continue;
            if (!column.isNull(i)) {
                this.writeToColumnBuilder(this.elseTransformer, column, i, columnBuilder);
                continue;
            }
            columnBuilder.appendNull();
        }
        this.initializeColumnCache(columnBuilder.build());
    }

    @Override
    protected void checkType() {
    }
}

