/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.input;

import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class ConstantInputReader
implements LayerPointReader {
    private final ConstantOperand expression;
    protected int cachedInt;
    protected long cachedLong;
    protected float cachedFloat;
    protected double cachedDouble;
    protected boolean cachedBoolean;
    protected Binary cachedBinary;

    public ConstantInputReader(ConstantOperand expression) throws QueryProcessException {
        this.expression = (ConstantOperand)Validate.notNull((Object)expression);
        Object value = CommonUtils.parseValue(expression.getDataType(), expression.getValueString());
        if (value == null) {
            throw new QueryProcessException("Invalid constant operand: " + expression.getExpressionString());
        }
        switch (expression.getDataType()) {
            case INT32: {
                this.cachedInt = (Integer)value;
                break;
            }
            case INT64: {
                this.cachedLong = (Long)value;
                break;
            }
            case FLOAT: {
                this.cachedFloat = ((Float)value).floatValue();
                break;
            }
            case DOUBLE: {
                this.cachedDouble = (Double)value;
                break;
            }
            case TEXT: {
                this.cachedBinary = (Binary)value;
                break;
            }
            case BOOLEAN: {
                this.cachedBoolean = (Boolean)value;
                break;
            }
            default: {
                throw new QueryProcessException("Unsupported type: " + expression.getDataType());
            }
        }
    }

    @Override
    public boolean isConstantPointReader() {
        return true;
    }

    @Override
    public YieldableState yield() {
        return YieldableState.YIELDABLE;
    }

    @Override
    public boolean next() {
        return true;
    }

    @Override
    public void readyForNext() {
    }

    @Override
    public TSDataType getDataType() {
        return this.expression.getDataType();
    }

    @Override
    public long currentTime() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int currentInt() throws IOException {
        return this.cachedInt;
    }

    @Override
    public long currentLong() throws IOException {
        return this.cachedLong;
    }

    @Override
    public float currentFloat() throws IOException {
        return this.cachedFloat;
    }

    @Override
    public double currentDouble() throws IOException {
        return this.cachedDouble;
    }

    @Override
    public boolean currentBoolean() throws IOException {
        return this.cachedBoolean;
    }

    @Override
    public Binary currentBinary() throws IOException {
        return this.cachedBinary;
    }

    @Override
    public boolean isCurrentNull() {
        return false;
    }
}

