/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class IsNullTransformer
extends UnaryTransformer {
    private final boolean isNot;

    public IsNullTransformer(LayerPointReader layerPointReader, boolean isNot) {
        super(layerPointReader);
        this.isNot = isNot;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    @Override
    public final YieldableState yieldValue() throws Exception {
        YieldableState yieldableState = this.layerPointReader.yield();
        if (!YieldableState.YIELDABLE.equals((Object)yieldableState)) {
            return yieldableState;
        }
        if (!this.isLayerPointReaderConstant) {
            this.cachedTime = this.layerPointReader.currentTime();
        }
        this.transformAndCache();
        this.layerPointReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        this.cachedBoolean = this.layerPointReader.isCurrentNull() ^ this.isNot;
    }
}

