/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.meta.DataNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoaderManager;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePluginAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginAgent.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final DataNodePipePluginMetaKeeper pipePluginMetaKeeper = new DataNodePipePluginMetaKeeper();

    public void acquireLock() {
        this.lock.lock();
    }

    public void releaseLock() {
        this.lock.unlock();
    }

    public void register(PipePluginMeta pipePluginMeta, ByteBuffer jarFile) throws Exception {
        this.acquireLock();
        try {
            this.deregister(pipePluginMeta.getPluginName(), false);
            this.checkIfRegistered(pipePluginMeta);
            this.saveJarFileIfNeeded(pipePluginMeta.getJarName(), jarFile);
            this.doRegister(pipePluginMeta);
        }
        finally {
            this.releaseLock();
        }
    }

    private void checkIfRegistered(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
        if (information == null) {
            return;
        }
        if (information.isBuiltin()) {
            String errorMessage = String.format("Failed to register PipePlugin %s, because the given PipePlugin name is the same as a built-in PipePlugin name.", pluginName);
            LOGGER.warn(errorMessage);
            throw new PipeException(errorMessage);
        }
        if (PipePluginExecutableManager.getInstance().hasFileUnderInstallDir(pipePluginMeta.getJarName()) && !PipePluginExecutableManager.getInstance().isLocalJarMatched(pipePluginMeta)) {
            String errMsg = String.format("Failed to register PipePlugin %s, because existed md5 of jar file for pipe plugin %s is different from the new jar file.", pluginName, pluginName);
            LOGGER.warn(errMsg);
            throw new PipeException(errMsg);
        }
    }

    private void saveJarFileIfNeeded(String jarName, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            PipePluginExecutableManager.getInstance().saveToInstallDir(byteBuffer, jarName);
        }
    }

    public void doRegister(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        String className = pipePluginMeta.getClassName();
        try {
            PipePluginClassLoader currentActiveClassLoader = PipePluginClassLoaderManager.getInstance().updateAndGetActiveClassLoader();
            this.updateAllRegisteredClasses(currentActiveClassLoader);
            Class<?> pluginClass = Class.forName(className, true, (ClassLoader)currentActiveClassLoader);
            PipePlugin ignored = (PipePlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.pipePluginMetaKeeper.addPipePluginMeta(pluginName, pipePluginMeta);
            this.pipePluginMetaKeeper.addPluginAndClass(pluginName, pluginClass);
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to register PipePlugin %s(%s), because its instance can not be constructed successfully. Exception: %s", pluginName.toUpperCase(), className, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new PipeException(errorMessage);
        }
    }

    private void updateAllRegisteredClasses(PipePluginClassLoader activeClassLoader) throws ClassNotFoundException {
        for (PipePluginMeta information : this.pipePluginMetaKeeper.getAllPipePluginMeta()) {
            this.pipePluginMetaKeeper.updatePluginClass(information, activeClassLoader);
        }
    }

    public void deregister(String pluginName, boolean needToDeleteJar) throws PipeException {
        this.acquireLock();
        try {
            PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
            if (information != null && information.isBuiltin()) {
                String errorMessage = String.format("Failed to deregister builtin PipePlugin %s.", pluginName);
                LOGGER.warn(errorMessage);
                throw new PipeException(errorMessage);
            }
            this.pipePluginMetaKeeper.removePipePluginMeta(pluginName);
            this.pipePluginMetaKeeper.removePluginClass(pluginName);
            if (information != null && needToDeleteJar) {
                PipePluginExecutableManager.getInstance().removeFileUnderLibRoot(information.getJarName());
                PipePluginExecutableManager.getInstance().removeFileUnderTemporaryRoot(pluginName.toUpperCase() + ".txt");
            }
        }
        catch (IOException e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseLock();
        }
    }

    public PipeExtractor reflectExtractor(PipeParameters extractorParameters) {
        return (PipeExtractor)this.reflect(extractorParameters.getStringOrDefault("extractor", BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()));
    }

    public PipeProcessor reflectProcessor(PipeParameters processorParameters) {
        return (PipeProcessor)this.reflect(processorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()));
    }

    public PipeConnector reflectConnector(PipeParameters connectorParameters) {
        if (!connectorParameters.hasAttribute("connector")) {
            throw new PipeException("Failed to reflect PipeConnector instance because 'connector' is not specified in the parameters.");
        }
        return (PipeConnector)this.reflect(connectorParameters.getString("connector"));
    }

    private PipePlugin reflect(String pluginName) {
        PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
        if (information == null) {
            String errorMessage = String.format("Failed to reflect PipePlugin instance, because PipePlugin %s has not been registered.", pluginName.toUpperCase());
            LOGGER.warn(errorMessage);
            throw new PipeException(errorMessage);
        }
        try {
            return (PipePlugin)this.pipePluginMetaKeeper.getPluginClass(pluginName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to reflect PipePlugin %s(%s) instance, because %s", pluginName, information.getClassName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new PipeException(errorMessage);
        }
    }
}

