/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v2.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.connector.v1.reponse.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferFileSealReq;
import org.apache.iotdb.db.pipe.connector.v2.IoTDBThriftConnectorV2;
import org.apache.iotdb.db.pipe.connector.v2.handler.PipeTransferTabletInsertionEventHandler;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTsFileInsertionEventHandler
implements AsyncMethodCallback<TPipeTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTsFileInsertionEventHandler.class);
    private final long requestCommitId;
    private final PipeTsFileInsertionEvent event;
    private final IoTDBThriftConnectorV2 connector;
    private final File tsFile;
    private final int readFileBufferSize;
    private final byte[] readBuffer;
    private long position;
    private RandomAccessFile reader;
    private final AtomicBoolean isSealSignalSent;
    private AsyncPipeDataTransferServiceClient client;
    private static final long MAX_RETRY_WAIT_TIME_MS = (long)((double)PipeConfig.getInstance().getPipeConnectorRetryIntervalMs() * Math.pow(2.0, 5.0));
    private int retryCount = 0;

    public PipeTransferTsFileInsertionEventHandler(long requestCommitId, PipeTsFileInsertionEvent event, IoTDBThriftConnectorV2 connector) throws FileNotFoundException {
        this.requestCommitId = requestCommitId;
        this.event = event;
        this.connector = connector;
        this.tsFile = event.getTsFile();
        this.readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        this.readBuffer = new byte[this.readFileBufferSize];
        this.position = 0L;
        this.reader = new RandomAccessFile(this.tsFile, "r");
        this.isSealSignalSent = new AtomicBoolean(false);
        event.increaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName());
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException, IOException {
        this.client = client;
        client.setShouldReturnSelf(false);
        int readLength = this.reader.read(this.readBuffer);
        if (readLength == -1) {
            this.isSealSignalSent.set(true);
            client.pipeTransfer((TPipeTransferReq)PipeTransferFileSealReq.toTPipeTransferReq(this.tsFile.getName(), this.tsFile.length()), (AsyncMethodCallback)this);
            return;
        }
        client.pipeTransfer((TPipeTransferReq)PipeTransferFilePieceReq.toTPipeTransferReq(this.tsFile.getName(), this.position, readLength == this.readFileBufferSize ? this.readBuffer : Arrays.copyOfRange(this.readBuffer, 0, readLength)), (AsyncMethodCallback)this);
        this.position += (long)readLength;
    }

    public void onComplete(TPipeTransferResp response) {
        if (this.isSealSignalSent.get()) {
            if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.onError((Exception)((Object)new PipeException(String.format("Seal file %s error, result status %s.", this.tsFile, response.getStatus()))));
                return;
            }
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close file reader.", (Throwable)e);
            }
            finally {
                if (this.client != null) {
                    this.client.setShouldReturnSelf(true);
                    this.client.returnSelf();
                }
                this.connector.commit(this.requestCommitId, this.event);
            }
            return;
        }
        try {
            PipeTransferFilePieceResp resp = PipeTransferFilePieceResp.fromTPipeTransferResp(response);
            long code = resp.getStatus().getCode();
            if (code == (long)TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                this.position = resp.getEndWritingOffset();
                this.reader.seek(this.position);
                LOGGER.info("Redirect file position to {}.", (Object)this.position);
            } else if (code != (long)TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new PipeException(String.format("Transfer file %s error, result status %s.", this.tsFile, resp.getStatus()));
            }
            this.transfer(this.client);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception exception) {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close file reader.", (Throwable)e);
        }
        finally {
            if (this.client != null) {
                this.client.setShouldReturnSelf(true);
                this.client.returnSelf();
            }
        }
        ++this.retryCount;
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(Math.min((long)((double)PipeConfig.getInstance().getPipeConnectorRetryIntervalMs() * Math.pow(2.0, (double)this.retryCount - 1.0)), MAX_RETRY_WAIT_TIME_MS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during retrying", (Throwable)e);
            }
            if (this.connector.isClosed()) {
                LOGGER.info("IoTDBThriftConnectorV2 has been stopped, we will not retry to transfer tsfile {}.", (Object)this.tsFile, (Object)exception);
            } else {
                LOGGER.warn("IoTDBThriftConnectorV2 failed to transfer tsfile {} after {} times, retrying...", new Object[]{this.tsFile, this.retryCount, exception});
                try {
                    this.position = 0L;
                    this.reader = new RandomAccessFile(this.tsFile, "r");
                    this.isSealSignalSent.set(false);
                    this.connector.transfer(this.requestCommitId, this);
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("Exception occurred when retrying...", (Throwable)e);
                    this.onError(e);
                }
            }
        });
    }
}

