/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionDataTabletIterator;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionDataContainer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionDataContainer.class);
    private final String pattern;
    private final IExpression timeFilterExpression;
    private final TsFileSequenceReader tsFileSequenceReader;
    private final TsFileReader tsFileReader;
    private final Iterator<Map.Entry<String, List<String>>> deviceMeasurementsMapIterator;
    private final Map<String, Boolean> deviceIsAlignedMap;
    private final Map<String, TSDataType> measurementDataTypeMap;

    public TsFileInsertionDataContainer(File tsFile, String pattern, long startTime, long endTime) throws IOException {
        this.pattern = pattern;
        this.timeFilterExpression = startTime == Long.MIN_VALUE && endTime == Long.MAX_VALUE ? null : BinaryExpression.and((IExpression)new GlobalTimeExpression((Filter)TimeFilter.gtEq((long)startTime)), (IExpression)new GlobalTimeExpression((Filter)TimeFilter.ltEq((long)endTime)));
        try {
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getAbsolutePath());
            this.tsFileReader = new TsFileReader(this.tsFileSequenceReader);
            this.deviceMeasurementsMapIterator = this.filterDeviceMeasurementsMapByPattern().entrySet().iterator();
            this.deviceIsAlignedMap = this.readDeviceIsAlignedMap();
            this.measurementDataTypeMap = this.tsFileSequenceReader.getFullPathDataTypeMap();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Map<String, List<String>> filterDeviceMeasurementsMapByPattern() throws IOException {
        HashMap<String, List<String>> filteredDeviceMeasurementsMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : this.tsFileSequenceReader.getDeviceMeasurementsMap().entrySet()) {
            String deviceId = (String)entry.getKey();
            if (this.pattern == null || this.pattern.length() <= deviceId.length() && deviceId.startsWith(this.pattern)) {
                if (((List)entry.getValue()).isEmpty()) continue;
                filteredDeviceMeasurementsMap.put(deviceId, (List)entry.getValue());
                continue;
            }
            if (this.pattern.length() <= deviceId.length() || !this.pattern.startsWith(deviceId)) continue;
            ArrayList<String> filteredMeasurements = new ArrayList<String>();
            for (String measurement : (List)entry.getValue()) {
                if (this.pattern.length() != deviceId.length() + measurement.length() + 1 || !this.pattern.endsWith("." + measurement)) continue;
                filteredMeasurements.add(measurement);
            }
            if (filteredMeasurements.isEmpty()) continue;
            filteredDeviceMeasurementsMap.put(deviceId, filteredMeasurements);
        }
        return filteredDeviceMeasurementsMap;
    }

    private Map<String, Boolean> readDeviceIsAlignedMap() throws IOException {
        HashMap<String, Boolean> deviceIsAlignedResultMap = new HashMap<String, Boolean>();
        TsFileDeviceIterator deviceIsAlignedIterator = this.tsFileSequenceReader.getAllDevicesIteratorWithIsAligned();
        while (deviceIsAlignedIterator.hasNext()) {
            Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
            deviceIsAlignedResultMap.put((String)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
        }
        return deviceIsAlignedResultMap;
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        return () -> new Iterator<TabletInsertionEvent>(){
            private TsFileInsertionDataTabletIterator tabletIterator = null;

            @Override
            public boolean hasNext() {
                while (this.tabletIterator == null || !this.tabletIterator.hasNext()) {
                    if (!TsFileInsertionDataContainer.this.deviceMeasurementsMapIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)TsFileInsertionDataContainer.this.deviceMeasurementsMapIterator.next();
                    try {
                        this.tabletIterator = new TsFileInsertionDataTabletIterator(TsFileInsertionDataContainer.this.tsFileReader, TsFileInsertionDataContainer.this.measurementDataTypeMap, (String)entry.getKey(), (List)entry.getValue(), TsFileInsertionDataContainer.this.timeFilterExpression);
                    }
                    catch (IOException e) {
                        TsFileInsertionDataContainer.this.close();
                        throw new PipeException("failed to create TsFileInsertionDataTabletIterator", (Throwable)e);
                    }
                }
                return true;
            }

            @Override
            public TabletInsertionEvent next() {
                if (!this.hasNext()) {
                    TsFileInsertionDataContainer.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = this.tabletIterator.next();
                boolean isAligned = TsFileInsertionDataContainer.this.deviceIsAlignedMap.getOrDefault(tablet.deviceId, false);
                PipeRawTabletInsertionEvent next = new PipeRawTabletInsertionEvent(tablet, isAligned);
                if (!this.hasNext()) {
                    TsFileInsertionDataContainer.this.close();
                }
                return next;
            }
        };
    }

    @Override
    public void close() {
        try {
            if (this.tsFileReader != null) {
                this.tsFileReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileReader", (Throwable)e);
        }
        try {
            if (this.tsFileSequenceReader != null) {
                this.tsFileSequenceReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileSequenceReader", (Throwable)e);
        }
    }
}

