/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionFakeExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionHybridExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionLogExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionTsFileExtractor;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionExtractor
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionExtractor.class);
    private final AtomicBoolean hasBeenStarted = new AtomicBoolean(false);
    private PipeHistoricalDataRegionExtractor historicalExtractor;
    private PipeRealtimeDataRegionExtractor realtimeExtractor;
    private int dataRegionId;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateAttributeValueRange("extractor.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("extractor.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, String.format("Should not set both %s and %s to false.", "extractor.history.enable", "extractor.realtime.enable"), new Object[]{validator.getParameters().getBooleanOrDefault("extractor.history.enable", true), validator.getParameters().getBooleanOrDefault("extractor.realtime.enable", true)});
        if (validator.getParameters().getBooleanOrDefault("extractor.realtime.enable", true)) {
            validator.validateAttributeValueRange("extractor.realtime.mode", true, new String[]{"hybrid", "file", "log"});
        }
        this.constructHistoricalExtractor();
        this.constructRealtimeExtractor(validator.getParameters());
        this.historicalExtractor.validate(validator);
        this.realtimeExtractor.validate(validator);
    }

    private void constructHistoricalExtractor() {
        this.historicalExtractor = new PipeHistoricalDataRegionTsFileExtractor();
    }

    private void constructRealtimeExtractor(PipeParameters parameters) {
        if (!parameters.getBooleanOrDefault("extractor.realtime.enable", true)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionFakeExtractor();
            return;
        }
        if (!parameters.hasAttribute("extractor.realtime.mode")) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHybridExtractor();
            return;
        }
        switch (parameters.getString("extractor.realtime.mode")) {
            case "file": {
                this.realtimeExtractor = new PipeRealtimeDataRegionTsFileExtractor();
                break;
            }
            case "log": {
                this.realtimeExtractor = new PipeRealtimeDataRegionLogExtractor();
                break;
            }
            case "hybrid": {
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridExtractor();
                break;
            }
            default: {
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridExtractor();
                LOGGER.warn("Unsupported extractor realtime mode: {}, create a hybrid extractor.", (Object)parameters.getString("extractor.realtime.mode"));
            }
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        this.dataRegionId = ((PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment()).getRegionId();
        this.historicalExtractor.customize(parameters, configuration);
        this.realtimeExtractor.customize(parameters, configuration);
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
        AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
        DataRegionId dataRegionIdObject = new DataRegionId(this.dataRegionId);
        while (true) {
            if (StorageEngine.getInstance().runIfPresent(dataRegionIdObject, dataRegion -> {
                dataRegion.writeLock(String.format("Pipe: starting %s", IoTDBDataRegionExtractor.class.getName()));
                try {
                    this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder);
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }) || StorageEngine.getInstance().runIfAbsent(dataRegionIdObject, () -> this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder))) {
                this.rethrowExceptionIfAny(exceptionHolder);
                return;
            }
            this.rethrowExceptionIfAny(exceptionHolder);
        }
    }

    private void startHistoricalExtractorAndRealtimeExtractor(AtomicReference<Exception> exceptionHolder) {
        try {
            this.historicalExtractor.start();
            this.realtimeExtractor.start();
        }
        catch (Exception e) {
            exceptionHolder.set(e);
            LOGGER.warn(String.format("Start historical extractor %s and realtime extractor %s error.", this.historicalExtractor, this.realtimeExtractor), (Throwable)e);
        }
    }

    private void rethrowExceptionIfAny(AtomicReference<Exception> exceptionHolder) {
        if (exceptionHolder.get() != null) {
            throw new PipeException("failed to start extractors.", (Throwable)exceptionHolder.get());
        }
    }

    public Event supply() throws Exception {
        return this.historicalExtractor.hasConsumedAll() ? this.realtimeExtractor.supply() : this.historicalExtractor.supply();
    }

    public void close() throws Exception {
        this.historicalExtractor.close();
        this.realtimeExtractor.close();
    }
}

