/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime.epoch;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpochStateMigrator;

public class TsFileEpoch {
    private final String filePath;
    private final ConcurrentMap<PipeRealtimeDataRegionExtractor, AtomicReference<State>> dataRegionExtractor2State;

    public TsFileEpoch(String filePath) {
        this.filePath = filePath;
        this.dataRegionExtractor2State = new ConcurrentHashMap<PipeRealtimeDataRegionExtractor, AtomicReference<State>>();
    }

    public State getState(PipeRealtimeDataRegionExtractor extractor) {
        return (State)((Object)this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).get());
    }

    public void migrateState(PipeRealtimeDataRegionExtractor extractor, TsFileEpochStateMigrator visitor) {
        this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).getAndUpdate(visitor::migrate);
    }

    public String toString() {
        return "TsFileEpoch{filePath='" + this.filePath + '\'' + ", dataRegionExtractor2State=" + this.dataRegionExtractor2State + '}';
    }

    public static enum State {
        EMPTY,
        USING_TABLET,
        USING_TSFILE;

    }
}

