/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;

public class InfluxMedianFunction
extends InfluxAggregator {
    private final List<Double> numbers = new ArrayList<Double>();

    public InfluxMedianFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        Collections.sort(this.numbers);
        int len = this.numbers.size();
        if (len > 0) {
            if (len % 2 == 0) {
                return new InfluxFunctionValue((this.numbers.get(len / 2) + this.numbers.get(len / 2 - 1)) / 2.0, 0L);
            }
            return new InfluxFunctionValue(this.numbers.get(len / 2), 0L);
        }
        return new InfluxFunctionValue(null, null);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFunctionName() {
        return "median";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        Object value = functionValue.getValue();
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("not support this type");
        }
        this.numbers.add(((Number)value).doubleValue());
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        throw new UnsupportedOperationException();
    }
}

