/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.util;

import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class FilterUtils {
    public static String getFilterStringValue(Filter filter) {
        String filterString = filter.toString();
        if (filter instanceof ValueFilter.ValueEq) {
            return filterString.split("== ")[1];
        }
        if (filter instanceof ValueFilter.ValueNotEq) {
            return filterString.split("!= ")[1];
        }
        if (filter instanceof ValueFilter.ValueLtEq) {
            return filterString.split("<= ")[1];
        }
        if (filter instanceof ValueFilter.ValueLt) {
            return filterString.split("< ")[1];
        }
        if (filter instanceof ValueFilter.ValueGtEq) {
            return filterString.split(">= ")[1];
        }
        if (filter instanceof ValueFilter.ValueGt) {
            return filterString.split("> ")[1];
        }
        throw new UnSupportedDataTypeException("Unsupported filter :" + filter);
    }

    public static String getFilerSymbol(Filter filter) {
        if (filter instanceof ValueFilter.ValueEq) {
            return "=";
        }
        if (filter instanceof ValueFilter.ValueNotEq) {
            return "!=";
        }
        if (filter instanceof ValueFilter.ValueLtEq) {
            return "<=";
        }
        if (filter instanceof ValueFilter.ValueLt) {
            return "<";
        }
        if (filter instanceof ValueFilter.ValueGtEq) {
            return ">=";
        }
        if (filter instanceof ValueFilter.ValueGt) {
            return ">";
        }
        throw new UnSupportedDataTypeException("Unsupported filter :" + filter);
    }

    public static Filter expressionTypeToFilter(ExpressionType expressionType, String value) {
        switch (expressionType) {
            case EQUAL_TO: {
                return ValueFilter.eq((Comparable)((Object)value));
            }
            case NON_EQUAL: {
                return ValueFilter.notEq((Comparable)((Object)value));
            }
            case LESS_EQUAL: {
                return ValueFilter.ltEq((Comparable)((Object)value));
            }
            case LESS_THAN: {
                return ValueFilter.lt((Comparable)((Object)value));
            }
            case GREATER_EQUAL: {
                return ValueFilter.gtEq((Comparable)((Object)value));
            }
            case GREATER_THAN: {
                return ValueFilter.gt((Comparable)((Object)value));
            }
        }
        throw new IllegalArgumentException("Unsupported expression type:" + (Object)((Object)expressionType));
    }
}

