/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManagerFactory;
import org.apache.iotdb.db.protocol.influxdb.util.CommonUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.rpc.IoTDBJDBCDataSet;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.QueryResult;

public class QueryResultUtils {
    public static void updateQueryResultColumnValue(QueryResult queryResult, List<String> columns, List<List<Object>> updateValues) {
        List results = queryResult.getResults();
        QueryResult.Result result = (QueryResult.Result)results.get(0);
        List series = ((QueryResult.Result)results.get(0)).getSeries();
        QueryResult.Series serie = (QueryResult.Series)series.get(0);
        serie.setValues(updateValues);
        serie.setColumns(columns);
        series.set(0, serie);
        result.setSeries(series);
        results.set(0, result);
    }

    public static QueryResult getNullQueryResult() {
        QueryResult queryResult = new QueryResult();
        QueryResult.Result result = new QueryResult.Result();
        queryResult.setResults(Arrays.asList(result));
        return queryResult;
    }

    private static void updateQueryResultValue(QueryResult queryResult, List<List<Object>> updateValues) {
        List results = queryResult.getResults();
        QueryResult.Result result = (QueryResult.Result)results.get(0);
        List series = ((QueryResult.Result)results.get(0)).getSeries();
        QueryResult.Series serie = (QueryResult.Series)series.get(0);
        serie.setValues(updateValues);
        series.set(0, serie);
        result.setSeries(series);
        results.set(0, result);
    }

    private static boolean checkSameQueryResult(QueryResult queryResult1, QueryResult queryResult2) {
        return ((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getName().equals(((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getName()) && StringUtils.checkSameStringList(((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getColumns(), ((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getColumns());
    }

    public static QueryResult orQueryResultProcess(QueryResult queryResult1, QueryResult queryResult2) {
        if (QueryResultUtils.checkQueryResultNull(queryResult1)) {
            return queryResult2;
        }
        if (QueryResultUtils.checkQueryResultNull(queryResult2)) {
            return queryResult1;
        }
        if (!QueryResultUtils.checkSameQueryResult(queryResult1, queryResult2)) {
            System.out.println("QueryResult1 and QueryResult2 is not same attribute");
            return queryResult1;
        }
        List values1 = ((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getValues();
        List values2 = ((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<List> notSameValuesInValues1 = new ArrayList<List>();
        for (List value1 : values1) {
            boolean allNotEqual = true;
            for (List value2 : values2) {
                boolean notEqual = false;
                for (int t = 0; t < value1.size(); ++t) {
                    if (CommonUtils.checkEqualsContainNull(value1.get(t), value2.get(t))) continue;
                    notEqual = true;
                    break;
                }
                if (notEqual) continue;
                allNotEqual = false;
                break;
            }
            if (!allNotEqual) continue;
            notSameValuesInValues1.add(value1);
        }
        values2.addAll(notSameValuesInValues1);
        QueryResultUtils.updateQueryResultValue(queryResult1, values2);
        return queryResult1;
    }

    public static QueryResult andQueryResultProcess(QueryResult queryResult1, QueryResult queryResult2) {
        if (QueryResultUtils.checkQueryResultNull(queryResult1) || QueryResultUtils.checkQueryResultNull(queryResult2)) {
            return QueryResultUtils.getNullQueryResult();
        }
        if (!QueryResultUtils.checkSameQueryResult(queryResult1, queryResult2)) {
            System.out.println("QueryResult1 and QueryResult2 is not same attribute");
            return queryResult1;
        }
        List values1 = ((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getValues();
        List values2 = ((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<List<Object>> sameValues = new ArrayList<List<Object>>();
        for (List value1 : values1) {
            for (List value2 : values2) {
                boolean allEqual = true;
                for (int t = 0; t < value1.size(); ++t) {
                    if (CommonUtils.checkEqualsContainNull(value1.get(t), value2.get(t))) continue;
                    allEqual = false;
                    break;
                }
                if (!allEqual) continue;
                sameValues.add(value1);
            }
        }
        QueryResultUtils.updateQueryResultValue(queryResult1, sameValues);
        return queryResult1;
    }

    public static boolean checkQueryResultNull(QueryResult queryResult) {
        return ((QueryResult.Result)queryResult.getResults().get(0)).getSeries() == null;
    }

    public static List<String> getFullPaths(TSExecuteStatementResp tsExecuteStatementResp) {
        ArrayList<String> res = new ArrayList<String>();
        IoTDBJDBCDataSet ioTDBJDBCDataSet = QueryResultUtils.creatIoTJDBCDataset(tsExecuteStatementResp);
        try {
            while (ioTDBJDBCDataSet.hasCachedResults()) {
                ioTDBJDBCDataSet.constructOneRow();
                String path = ioTDBJDBCDataSet.getValueByName("Timeseries");
                res.add(path);
            }
        }
        catch (StatementExecutionException e) {
            throw new InfluxDBException(e.getMessage());
        }
        return res;
    }

    public static QueryResult iotdbResultConvertInfluxResult(TSExecuteStatementResp tsExecuteStatementResp, String database, String measurement, Map<String, Integer> fieldOrders) {
        if (tsExecuteStatementResp == null) {
            return QueryResultUtils.getNullQueryResult();
        }
        QueryResult.Series series = new QueryResult.Series();
        series.setName(measurement);
        Map<String, Integer> tagOrders = InfluxDBMetaManagerFactory.getInstance().getTagOrders(database, measurement, -1L);
        Map<Integer, String> tagOrderReversed = tagOrders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<Integer, String> fieldOrdersReversed = fieldOrders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        int tagSize = tagOrderReversed.size();
        ArrayList<String> tagList = new ArrayList<String>();
        for (int i = 1; i <= tagSize; ++i) {
            tagList.add(tagOrderReversed.get(i));
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 1 + tagSize; i < 1 + tagSize + fieldOrders.size(); ++i) {
            fieldList.add(fieldOrdersReversed.get(i));
        }
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("time");
        columns.addAll(tagList);
        columns.addAll(fieldList);
        series.setColumns(columns);
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        IoTDBJDBCDataSet ioTDBJDBCDataSet = QueryResultUtils.creatIoTJDBCDataset(tsExecuteStatementResp);
        try {
            while (ioTDBJDBCDataSet.hasCachedResults()) {
                int i;
                Object[] value = new Object[columns.size()];
                ioTDBJDBCDataSet.constructOneRow();
                value[0] = Long.valueOf(ioTDBJDBCDataSet.getValueByName("Time"));
                String deviceName = ioTDBJDBCDataSet.getValueByName("Device");
                String[] deviceNameList = deviceName.split("\\.");
                for (i = 3; i < deviceNameList.length; ++i) {
                    if (deviceNameList[i].equals("PH")) continue;
                    value[i - 2] = deviceNameList[i];
                }
                for (i = 3; i <= ioTDBJDBCDataSet.columnNameList.size(); ++i) {
                    Object o = ioTDBJDBCDataSet.getObject(ioTDBJDBCDataSet.findColumnNameByIndex(i));
                    if (o == null) continue;
                    value[fieldOrders.get((Object)ioTDBJDBCDataSet.findColumnNameByIndex((int)i)).intValue()] = o;
                }
                values.add(Arrays.asList(value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        series.setValues(values);
        QueryResult queryResult = new QueryResult();
        QueryResult.Result result = new QueryResult.Result();
        result.setSeries(new ArrayList<QueryResult.Series>(Arrays.asList(series)));
        queryResult.setResults(new ArrayList<QueryResult.Result>(Arrays.asList(result)));
        return queryResult;
    }

    public static QueryResult iotdbResultConvertInfluxResult(TSExecuteStatementResp tsExecuteStatementResp, String database, String measurement, Map<String, Integer> tagOrders, Map<String, Integer> fieldOrders) {
        if (tsExecuteStatementResp == null) {
            return QueryResultUtils.getNullQueryResult();
        }
        QueryResult.Series series = new QueryResult.Series();
        series.setName(measurement);
        Map<Integer, String> tagOrderReversed = tagOrders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        int tagSize = tagOrderReversed.size();
        Map<Integer, String> fieldOrdersReversed = fieldOrders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ArrayList<String> tagList = new ArrayList<String>();
        for (int i = 0; i < tagSize; ++i) {
            tagList.add(tagOrderReversed.get(i));
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < fieldOrders.size(); ++i) {
            fieldList.add(fieldOrdersReversed.get(i));
        }
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("time");
        columns.addAll(tagList);
        columns.addAll(fieldList);
        series.setColumns(columns);
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        IoTDBJDBCDataSet ioTDBJDBCDataSet = QueryResultUtils.creatIoTJDBCDataset(tsExecuteStatementResp);
        try {
            while (ioTDBJDBCDataSet.hasCachedResults()) {
                int i;
                Object[] value = new Object[columns.size()];
                ioTDBJDBCDataSet.constructOneRow();
                value[0] = Long.valueOf(ioTDBJDBCDataSet.getValueByName("Time"));
                String deviceName = ioTDBJDBCDataSet.getValueByName("Device");
                String[] deviceNameList = deviceName.split("\\.");
                for (i = 2; i < deviceNameList.length; i += 2) {
                    if (!tagOrders.containsKey(deviceNameList[i])) continue;
                    int position = tagOrders.get(deviceNameList[i]) + 1;
                    value[position] = deviceNameList[i + 1];
                }
                for (i = 3; i <= ioTDBJDBCDataSet.columnNameList.size(); ++i) {
                    Object o = ioTDBJDBCDataSet.getObject(ioTDBJDBCDataSet.findColumnNameByIndex(i));
                    if (o == null) continue;
                    int position = fieldOrders.get(ioTDBJDBCDataSet.findColumnNameByIndex(i)) + tagSize + 1;
                    value[position] = o;
                }
                values.add(Arrays.asList(value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        series.setValues(values);
        QueryResult queryResult = new QueryResult();
        QueryResult.Result result = new QueryResult.Result();
        result.setSeries(new ArrayList<QueryResult.Series>(Arrays.asList(series)));
        queryResult.setResults(new ArrayList<QueryResult.Result>(Arrays.asList(result)));
        return queryResult;
    }

    public static List<InfluxFunctionValue> getInfluxFunctionValues(TSExecuteStatementResp tsExecuteStatementResp) {
        IoTDBJDBCDataSet ioTDBJDBCDataSet = QueryResultUtils.creatIoTJDBCDataset(tsExecuteStatementResp);
        ArrayList<InfluxFunctionValue> result = new ArrayList<InfluxFunctionValue>(ioTDBJDBCDataSet.columnSize);
        try {
            while (ioTDBJDBCDataSet.hasCachedResults()) {
                ioTDBJDBCDataSet.constructOneRow();
                Long timestamp = null;
                for (String columnName : ioTDBJDBCDataSet.columnNameList) {
                    if ("Time".equals(columnName)) {
                        timestamp = ioTDBJDBCDataSet.getTimestamp(columnName).getTime();
                        continue;
                    }
                    Object o = ioTDBJDBCDataSet.getObject(columnName);
                    result.add(new InfluxFunctionValue(o, timestamp));
                }
            }
        }
        catch (StatementExecutionException e) {
            throw new InfluxDBException(e.getMessage());
        }
        return result;
    }

    public static Map<String, Object> getColumnNameAndValue(TSExecuteStatementResp tsExecuteStatementResp) {
        IoTDBJDBCDataSet ioTDBJDBCDataSet = QueryResultUtils.creatIoTJDBCDataset(tsExecuteStatementResp);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            while (ioTDBJDBCDataSet.hasCachedResults()) {
                ioTDBJDBCDataSet.constructOneRow();
                for (String columnName : ioTDBJDBCDataSet.columnNameList) {
                    Object o = ioTDBJDBCDataSet.getObject(columnName);
                    result.put(columnName, o);
                }
            }
        }
        catch (StatementExecutionException e) {
            throw new InfluxDBException(e.getMessage());
        }
        return result;
    }

    public static IoTDBJDBCDataSet creatIoTJDBCDataset(TSExecuteStatementResp tsExecuteStatementResp) {
        return new IoTDBJDBCDataSet(null, tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.ignoreTimeStamp, tsExecuteStatementResp.queryId, 0L, null, 0L, tsExecuteStatementResp.queryDataSet, 0, 0L, tsExecuteStatementResp.sgColumns, null);
    }
}

