/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control.clientsession;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.service.rpc.thrift.TSConnectionType;

public class ClientSession
extends IClientSession {
    private final Socket clientSocket;
    private final Map<Long, Set<Long>> statementIdToQueryId = new ConcurrentHashMap<Long, Set<Long>>();

    public ClientSession(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    @Override
    public String getClientAddress() {
        return this.clientSocket.getInetAddress().getHostAddress();
    }

    @Override
    public int getClientPort() {
        return this.clientSocket.getPort();
    }

    @Override
    TSConnectionType getConnectionType() {
        return TSConnectionType.THRIFT_BASED;
    }

    @Override
    String getConnectionId() {
        return this.getClientAddress() + ':' + this.getClientPort();
    }

    public Set<Long> getStatementIds() {
        return this.statementIdToQueryId.keySet();
    }

    @Override
    public void addStatementId(long statementId) {
        this.statementIdToQueryId.computeIfAbsent(statementId, sid -> ConcurrentHashMap.newKeySet());
    }

    @Override
    public Set<Long> removeStatementId(long statementId) {
        return this.statementIdToQueryId.remove(statementId);
    }

    @Override
    public void addQueryId(Long statementId, long queryId) {
        Set<Long> queryIds = this.statementIdToQueryId.get(statementId);
        if (queryIds == null) {
            throw new IllegalStateException("StatementId: " + statementId + " doesn't exist in this session " + this);
        }
        queryIds.add(queryId);
    }

    @Override
    public void removeQueryId(Long statementId, Long queryId) {
        Set<Long> queryIds = this.statementIdToQueryId.get(statementId);
        if (queryIds != null) {
            queryIds.remove(queryId);
        }
    }

    public void shutdownStream() {
        if (!this.clientSocket.isInputShutdown()) {
            try {
                this.clientSocket.shutdownInput();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.clientSocket.isOutputShutdown()) {
            try {
                this.clientSocket.shutdownOutput();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

