/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control.clientsession;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.service.rpc.thrift.TSConnectionType;

public class InternalClientSession
extends IClientSession {
    private final String clientID;
    private final Map<Long, Set<Long>> statementIdToQueryId = new ConcurrentHashMap<Long, Set<Long>>();

    public InternalClientSession(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    @Override
    public String getClientAddress() {
        return this.clientID;
    }

    @Override
    public int getClientPort() {
        return 0;
    }

    @Override
    TSConnectionType getConnectionType() {
        return TSConnectionType.INTERNAL;
    }

    @Override
    String getConnectionId() {
        return this.clientID;
    }

    public Set<Long> getStatementIds() {
        return this.statementIdToQueryId.keySet();
    }

    @Override
    public void addStatementId(long statementId) {
        this.statementIdToQueryId.computeIfAbsent(statementId, sid -> new CopyOnWriteArraySet());
    }

    @Override
    public Set<Long> removeStatementId(long statementId) {
        return this.statementIdToQueryId.remove(statementId);
    }

    @Override
    public void addQueryId(Long statementId, long queryId) {
        Set<Long> queryIds = this.statementIdToQueryId.get(statementId);
        if (queryIds == null) {
            throw new IllegalStateException("StatementId: " + statementId + "doesn't exist in this session " + this);
        }
        queryIds.add(queryId);
    }

    @Override
    public void removeQueryId(Long statementId, Long queryId) {
        Set<Long> queryIds = this.statementIdToQueryId.get(statementId);
        if (queryIds != null) {
            queryIds.remove(queryId);
        }
    }
}

