/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.service;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeClientManager;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerInformationUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerInformationUpdater.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private final ScheduledExecutorService triggerInformationUpdateExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Stateful-Trigger-Information-Updater");
    private Future<?> updateFuture;
    private static final long UPDATE_INTERVAL = 60000L;

    public void startTriggerInformationUpdater() {
        if (this.updateFuture == null) {
            this.updateFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.triggerInformationUpdateExecutor, this::updateTask, (long)60000L, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
            LOGGER.info("Stateful-Trigger-Information-Updater is successfully started.");
        }
    }

    public void stopTriggerInformationUpdater() {
        if (this.updateFuture != null) {
            this.updateFuture.cancel(false);
            this.updateFuture = null;
            LOGGER.info("Stateful-Trigger-Information-Updater is successfully stopped.");
        }
    }

    public void updateTask() {
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetTriggerTableResp getStatefulTriggerTableResp = client.getStatefulTriggerTable();
            if (getStatefulTriggerTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBException(getStatefulTriggerTableResp.getStatus().getMessage(), getStatefulTriggerTableResp.getStatus().getCode());
            }
            List statefulTriggerInformationList = getStatefulTriggerTableResp.getAllTriggerInformation().stream().map(TriggerInformation::deserialize).collect(Collectors.toList());
            for (TriggerInformation triggerInformation : statefulTriggerInformationList) {
                TriggerManagementService.getInstance().updateLocationOfStatefulTrigger(triggerInformation.getTriggerName(), triggerInformation.getDataNodeLocation());
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Meet error when updating trigger information: %s", e));
        }
    }
}

