/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.BackIntTVList;
import org.apache.iotdb.db.utils.datastructure.QuickIntTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.utils.datastructure.TimIntTVList;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public abstract class IntTVList
extends TVList {
    protected List<int[]> values = new ArrayList<int[]>();

    IntTVList() {
    }

    public static IntTVList newList() {
        switch (PrimitiveArrayManager.TVLIST_SORT_ALGORITHM) {
            case QUICK: {
                return new QuickIntTVList();
            }
            case BACKWARD: {
                return new BackIntTVList();
            }
        }
        return new TimIntTVList();
    }

    @Override
    public IntTVList clone() {
        IntTVList cloneList = IntTVList.newList();
        this.cloneAs(cloneList);
        for (int[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private int[] cloneValue(int[] array) {
        int[] cloneArray = new int[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void putInt(long timestamp, int value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.maxTime = Math.max(this.maxTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.rowCount;
        if (this.sorted && this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public int getInt(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, int value) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (int[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)this.getInt(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)this.getInt(index)));
    }

    @Override
    protected void writeValidValuesIntoTsBlock(TsBlockBuilder builder, int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        Integer deleteCursor = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            if (this.isPointDeleted(this.getTime(i), deletionList, deleteCursor) || i != this.rowCount - 1 && this.getTime(i) == this.getTime(i + 1)) continue;
            builder.getTimeColumnBuilder().writeLong(this.getTime(i));
            builder.getColumnBuilder(0).writeInt(this.getInt(i));
            builder.declarePosition();
        }
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putInts(long[] time, int[] value, BitMap bitMap, int start, int end) {
        this.checkExpansion();
        int idx = start;
        int timeIdxOffset = 0;
        if (bitMap != null && !bitMap.isAllUnmarked()) {
            long[] clonedTime = new long[end - start];
            System.arraycopy(time, start, clonedTime, 0, end - start);
            time = clonedTime;
            timeIdxOffset = start;
            int nullCnt = this.dropNullValThenUpdateMaxTimeAndSorted(time, value, bitMap, start, end, timeIdxOffset);
            end -= nullCnt;
        } else {
            this.updateMaxTimeAndSorted(time, start, end);
        }
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.rowCount += inputRemaining;
                break;
            }
            System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.rowCount += internalRemaining;
            this.checkExpansion();
        }
    }

    int dropNullValThenUpdateMaxTimeAndSorted(long[] time, int[] values, BitMap bitMap, int start, int end, int tIdxOffset) {
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int nullCnt = 0;
        for (int vIdx = start; vIdx < end; ++vIdx) {
            if (bitMap.isMarked(vIdx)) {
                ++nullCnt;
                continue;
            }
            int tIdx = vIdx - tIdxOffset;
            if (nullCnt != 0) {
                time[tIdx - nullCnt] = time[tIdx];
                values[vIdx - nullCnt] = values[vIdx];
            }
            inPutMinTime = Math.min(inPutMinTime, time[tIdx -= nullCnt]);
            this.maxTime = Math.max(this.maxTime, time[tIdx]);
            if (!inputSorted || tIdx <= 0 || time[tIdx - 1] <= time[tIdx]) continue;
            inputSorted = false;
        }
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
        return nullCnt;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.INT32;
    }

    @Override
    public int serializedSize() {
        return 5 + this.rowCount * 12;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(TSDataType.INT32, buffer);
        buffer.putInt(this.rowCount);
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            buffer.putLong(this.getTime(rowIdx));
            buffer.putInt(this.getInt(rowIdx));
        }
    }

    public static IntTVList deserialize(DataInputStream stream) throws IOException {
        IntTVList tvList = IntTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        int[] values = new int[rowCount];
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = stream.readInt();
        }
        tvList.putInts(times, values, null, 0, rowCount);
        return tvList;
    }
}

