/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.buffer;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.utils.WALMode;

public class WALInfoEntry
extends WALEntry {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final int FIXED_SERIALIZED_SIZE = 9;
    private TabletInfo tabletInfo;

    public WALInfoEntry(long memTableId, WALEntryValue value, boolean wait) {
        super(memTableId, value, wait);
    }

    public WALInfoEntry(long memTableId, WALEntryValue value) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        if (value instanceof InsertTabletNode) {
            this.tabletInfo = new TabletInfo(0, ((InsertTabletNode)value).getRowCount());
        }
    }

    public WALInfoEntry(long memTableId, InsertTabletNode value, int tabletStart, int tabletEnd) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        this.tabletInfo = new TabletInfo(tabletStart, tabletEnd);
    }

    WALInfoEntry(WALEntryType type, long memTableId, WALEntryValue value) {
        super(type, memTableId, value, false);
    }

    @Override
    public int serializedSize() {
        return 9 + (this.value == null ? 0 : this.value.serializedSize());
    }

    @Override
    public void serialize(IWALByteBufferView buffer) {
        buffer.put(this.type.getCode());
        buffer.putLong(this.memTableId);
        switch (this.type) {
            case INSERT_TABLET_NODE: {
                ((InsertTabletNode)this.value).serializeToWAL(buffer, this.tabletInfo.tabletStart, this.tabletInfo.tabletEnd);
                break;
            }
            case INSERT_ROW_NODE: 
            case DELETE_DATA_NODE: 
            case MEMORY_TABLE_SNAPSHOT: {
                this.value.serializeToWAL(buffer);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported wal entry type " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public boolean isSignal() {
        return false;
    }

    private static class TabletInfo {
        private final int tabletStart;
        private final int tabletEnd;

        public TabletInfo(int tabletStart, int tabletEnd) {
            this.tabletStart = tabletStart;
            this.tabletEnd = tabletEnd;
        }
    }
}

