/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Optional;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class BinaryColumn
implements Column {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryColumn.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final Binary[] values;
    private final long retainedSizeInBytes;

    public BinaryColumn(int positionCount, Optional<boolean[]> valueIsNull, Binary[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    BinaryColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, Binary[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOfBooleanArray((int)positionCount) + SizeOf.sizeOfObjectArray((int)positionCount);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    @Override
    public ColumnEncoding getEncoding() {
        return ColumnEncoding.BINARY_ARRAY;
    }

    @Override
    public Binary getBinary(int position) {
        return this.values[position + this.arrayOffset];
    }

    @Override
    public Binary[] getBinaries() {
        return this.values;
    }

    @Override
    public Object getObject(int position) {
        return this.getBinary(position);
    }

    @Override
    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsBinary(this.getBinary(position));
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new BinaryColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new BinaryColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    @Override
    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            Binary valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }

    @Override
    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }
}

