/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.Between;
import org.apache.iotdb.tsfile.read.filter.operator.Eq;
import org.apache.iotdb.tsfile.read.filter.operator.Gt;
import org.apache.iotdb.tsfile.read.filter.operator.GtEq;
import org.apache.iotdb.tsfile.read.filter.operator.In;
import org.apache.iotdb.tsfile.read.filter.operator.Lt;
import org.apache.iotdb.tsfile.read.filter.operator.LtEq;
import org.apache.iotdb.tsfile.read.filter.operator.NotEq;
import org.apache.iotdb.tsfile.read.filter.operator.OrFilter;

public class TimeFilter {
    private TimeFilter() {
    }

    public static TimeGt gt(long value) {
        return new TimeGt(value);
    }

    public static TimeGtEq gtEq(long value) {
        return new TimeGtEq(value);
    }

    public static TimeLt lt(long value) {
        return new TimeLt(value);
    }

    public static TimeLtEq ltEq(long value) {
        return new TimeLtEq(value);
    }

    public static TimeEq eq(long value) {
        return new TimeEq(value);
    }

    public static TimeNotEq notEq(long value) {
        return new TimeNotEq(value);
    }

    public static TimeBetween between(long value1, long value2) {
        return new TimeBetween(value1, value2, false);
    }

    public static TimeBetween notBetween(long value1, long value2) {
        return new TimeBetween(value1, value2, true);
    }

    public static TimeIn in(Set<Long> values) {
        return new TimeIn(values, false);
    }

    public static TimeIn notIn(Set<Long> values) {
        return new TimeIn(values, true);
    }

    public static Filter defaultTimeFilter(boolean ascending) {
        return ascending ? TimeFilter.gtEq(Long.MIN_VALUE) : TimeFilter.ltEq(Long.MAX_VALUE);
    }

    public static class TimeGtEqAndLt
    implements Filter {
        private long startTime;
        private long endTime;

        public TimeGtEqAndLt() {
        }

        public TimeGtEqAndLt(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        @Override
        public boolean satisfy(Statistics statistics) {
            return statistics.getEndTime() >= this.startTime && statistics.getStartTime() < this.endTime;
        }

        @Override
        public boolean allSatisfy(Statistics statistics) {
            return this.startTime <= statistics.getStartTime() && statistics.getEndTime() < this.endTime;
        }

        @Override
        public boolean satisfy(long time, Object value) {
            return this.startTime <= time && time < this.endTime;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return endTime >= this.startTime && startTime < this.endTime;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return this.startTime <= startTime && endTime < this.endTime;
        }

        @Override
        public Filter copy() {
            return new TimeGtEqAndLt(this.startTime, this.endTime);
        }

        public String toString() {
            return "TimeGtEqAndLt{startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
        }

        @Override
        public void serialize(DataOutputStream outputStream) {
            try {
                outputStream.write(this.getSerializeId().ordinal());
                outputStream.writeLong(this.startTime);
                outputStream.writeLong(this.endTime);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void deserialize(ByteBuffer buffer) {
            this.startTime = buffer.getLong();
            this.endTime = buffer.getLong();
        }

        @Override
        public FilterSerializeId getSerializeId() {
            return FilterSerializeId.TIME_GTEQ_AND_LT;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return this.startTime >= this.endTime ? Collections.emptyList() : Collections.singletonList(new TimeRange(this.startTime, this.endTime - 1L));
        }

        @Override
        public Filter reverse() {
            return new OrFilter(new TimeLt(this.startTime), new TimeGtEq(this.endTime));
        }
    }

    public static class TimeIn
    extends In<Long> {
        private TimeIn(Set<Long> values, boolean not) {
            super(values, FilterType.TIME_FILTER, not);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.not) {
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            return this.values.stream().map(l -> {
                long time = l;
                return new TimeRange(time, time);
            }).collect(Collectors.toList());
        }
    }

    public static class TimeBetween
    extends Between<Long> {
        private TimeBetween(long value1, long value2, boolean not) {
            super(value1, value2, FilterType.TIME_FILTER, not);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long left = (Long)this.value1;
            long right = (Long)this.value2;
            if (this.not) {
                ArrayList<TimeRange> res = new ArrayList<TimeRange>();
                if (left != Long.MIN_VALUE) {
                    res.add(new TimeRange(Long.MIN_VALUE, left - 1L));
                }
                if (right != Long.MAX_VALUE) {
                    res.add(new TimeRange(right + 1L, Long.MAX_VALUE));
                }
                return res;
            }
            return Collections.singletonList(new TimeRange(left, right));
        }
    }

    public static class TimeNotEq
    extends NotEq<Long> {
        private TimeNotEq(long value) {
            super(value, FilterType.TIME_FILTER);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long time = (Long)this.value;
            if (time == Long.MIN_VALUE) {
                return Collections.singletonList(new TimeRange(time + 1L, Long.MAX_VALUE));
            }
            if (time == Long.MAX_VALUE) {
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, time - 1L));
            }
            return Arrays.asList(new TimeRange(Long.MIN_VALUE, time - 1L), new TimeRange(time + 1L, Long.MAX_VALUE));
        }
    }

    public static class TimeEq
    extends Eq<Long> {
        private TimeEq(long value) {
            super(value, FilterType.TIME_FILTER);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange((Long)this.value, (Long)this.value));
        }
    }

    public static class TimeLtEq
    extends LtEq<Long> {
        private TimeLtEq(long value) {
            super(value, FilterType.TIME_FILTER);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, (Long)this.value));
        }
    }

    public static class TimeLt
    extends Lt<Long> {
        private TimeLt(long value) {
            super(value, FilterType.TIME_FILTER);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long right = (Long)this.value;
            if (right != Long.MIN_VALUE) {
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, right - 1L));
            }
            return Collections.emptyList();
        }
    }

    public static class TimeGtEq
    extends GtEq<Long> {
        private TimeGtEq(long value) {
            super(value, FilterType.TIME_FILTER);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange((Long)this.value, Long.MAX_VALUE));
        }
    }

    public static class TimeGt
    extends Gt<Long> {
        private TimeGt(long value) {
            super(value, FilterType.TIME_FILTER);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long left = (Long)this.value;
            if (left != Long.MAX_VALUE) {
                return Collections.singletonList(new TimeRange(left + 1L, Long.MAX_VALUE));
            }
            return Collections.emptyList();
        }
    }
}

