/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.BinaryFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;

public class AndFilter
extends BinaryFilter {
    private static final long serialVersionUID = -8212850098906044102L;

    public AndFilter() {
    }

    public AndFilter(Filter left, Filter right) {
        super(left, right);
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return this.left.satisfy(statistics) && this.right.satisfy(statistics);
    }

    @Override
    public boolean allSatisfy(Statistics statistics) {
        return this.left.allSatisfy(statistics) && this.right.allSatisfy(statistics);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.left.satisfy(time, value) && this.right.satisfy(time, value);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return this.left.satisfyStartEndTime(startTime, endTime) && this.right.satisfyStartEndTime(startTime, endTime);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return this.left.containStartEndTime(startTime, endTime) && this.right.containStartEndTime(startTime, endTime);
    }

    public String toString() {
        return "(" + this.left + " && " + this.right + ")";
    }

    @Override
    public Filter copy() {
        return new AndFilter(this.left.copy(), this.right.copy());
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.AND;
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        List<TimeRange> leftTimeRanges = this.left.getTimeRanges();
        List<TimeRange> rightTimeRanges = this.right.getTimeRanges();
        int leftIndex = 0;
        int rightIndex = 0;
        int leftSize = leftTimeRanges.size();
        int rightSize = rightTimeRanges.size();
        while (leftIndex < leftSize && rightIndex < rightSize) {
            TimeRange leftRange = leftTimeRanges.get(leftIndex);
            TimeRange rightRange = rightTimeRanges.get(rightIndex);
            if (leftRange.getMax() < rightRange.getMin()) {
                ++leftIndex;
                continue;
            }
            if (rightRange.getMax() < leftRange.getMin()) {
                ++rightIndex;
                continue;
            }
            TimeRange intersection = new TimeRange(Math.max(leftRange.getMin(), rightRange.getMin()), Math.min(leftRange.getMax(), rightRange.getMax()));
            result.add(intersection);
            if (leftRange.getMax() <= intersection.getMax()) {
                ++leftIndex;
            }
            if (rightRange.getMax() > intersection.getMax()) continue;
            ++rightIndex;
        }
        return result;
    }

    @Override
    public Filter reverse() {
        return FilterFactory.or(this.left.reverse(), this.right.reverse());
    }
}

