/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AbstractAsyncRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatRPCHandler
extends AbstractAsyncRPCHandler<TPipeHeartbeatResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatRPCHandler.class);

    public PipeHeartbeatRPCHandler(DataNodeRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TPipeHeartbeatResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TPipeHeartbeatResp response) {
        this.responseMap.put(this.requestId, response);
        this.dataNodeLocationMap.remove(this.requestId);
        LOGGER.info("Successfully {} on DataNode: {}", (Object)this.requestType, (Object)this.formattedTargetLocation);
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        LOGGER.error("Failed to " + (Object)((Object)this.requestType) + " on DataNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage());
        this.countDownLatch.countDown();
    }
}

