/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.udf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GetUDFJarPlan
extends ConfigPhysicalPlan {
    private List<String> jarNames;

    public GetUDFJarPlan() {
        super(ConfigPhysicalPlanType.GetFunctionJar);
    }

    public GetUDFJarPlan(List<String> triggerNames) {
        super(ConfigPhysicalPlanType.GetFunctionJar);
        this.jarNames = triggerNames;
    }

    public List<String> getJarNames() {
        return this.jarNames;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((int)this.jarNames.size(), (OutputStream)stream);
        for (String jarName : this.jarNames) {
            ReadWriteIOUtils.write((String)jarName, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size;
        this.jarNames = new ArrayList<String>(size);
        for (size = ReadWriteIOUtils.readInt((ByteBuffer)buffer); size > 0; --size) {
            this.jarNames.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
    }
}

