/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.route;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.tsfile.utils.Pair;

public class RegionRouteCache {
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getSchemaRegionConsensusProtocolClass();
    private static final String DATA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getDataRegionConsensusProtocolClass();
    public static final int unReadyLeaderId = -1;
    public static final TRegionReplicaSet unReadyRegionPriority = new TRegionReplicaSet();
    private final String consensusProtocolClass;
    private final AtomicReference<Pair<Long, Integer>> leaderSample;
    private final AtomicInteger leaderId;
    private final AtomicReference<TRegionReplicaSet> regionPriority;

    public RegionRouteCache(TConsensusGroupId consensusGroupId) {
        switch (consensusGroupId.getType()) {
            case SchemaRegion: {
                this.consensusProtocolClass = SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS;
                break;
            }
            default: {
                this.consensusProtocolClass = DATA_REGION_CONSENSUS_PROTOCOL_CLASS;
            }
        }
        this.leaderSample = new AtomicReference<Pair>(new Pair((Object)0L, (Object)-1));
        this.leaderId = new AtomicInteger(-1);
        this.regionPriority = new AtomicReference<TRegionReplicaSet>(new TRegionReplicaSet());
    }

    public synchronized void cacheLeaderSample(Pair<Long, Integer> leaderSample) {
        switch (this.consensusProtocolClass) {
            case "org.apache.iotdb.consensus.simple.SimpleConsensus": 
            case "org.apache.iotdb.consensus.ratis.RatisConsensus": {
                if ((Long)leaderSample.getLeft() <= (Long)this.leaderSample.get().getLeft()) break;
                this.leaderSample.set(leaderSample);
                break;
            }
        }
    }

    public boolean periodicUpdate() {
        switch (this.consensusProtocolClass) {
            case "org.apache.iotdb.consensus.simple.SimpleConsensus": 
            case "org.apache.iotdb.consensus.ratis.RatisConsensus": {
                if (((Integer)this.leaderSample.get().getRight()).intValue() != this.leaderId.get()) {
                    this.leaderId.set((Integer)this.leaderSample.get().getRight());
                    return true;
                }
                return false;
            }
        }
        return this.leaderId.get() == -1;
    }

    public void forceUpdateRegionLeader(int leaderId) {
        this.leaderId.set(leaderId);
    }

    public void forceUpdateRegionPriority(TRegionReplicaSet regionPriority) {
        this.regionPriority.set(regionPriority);
    }

    public boolean isRegionGroupUnready() {
        return -1 == this.leaderId.get() || unReadyRegionPriority.equals(this.regionPriority.get());
    }

    public int getLeaderId() {
        return this.leaderId.get();
    }

    public TRegionReplicaSet getRegionPriority() {
        return this.regionPriority.get();
    }
}

