/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.runtime;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeMetaSyncer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeMetaSyncer.class);
    private static final ScheduledExecutorService SYNC_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_RUNTIME_META_SYNCER.getName());
    private static final long INITIAL_SYNC_DELAY_MINUTES = PipeConfig.getInstance().getPipeMetaSyncerInitialSyncDelayMinutes();
    private static final long SYNC_INTERVAL_MINUTES = PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes();
    private final ConfigManager configManager;
    private Future<?> metaSyncFuture;

    PipeMetaSyncer(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public synchronized void start() {
        while (this.configManager.getConsensusManager() == null) {
            try {
                LOGGER.info("consensus layer is not ready, sleep 1s...");
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("unexpected interruption during waiting for consensus layer ready.");
            }
        }
        if (this.metaSyncFuture == null) {
            this.metaSyncFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)SYNC_EXECUTOR, this::sync, (long)INITIAL_SYNC_DELAY_MINUTES, (long)SYNC_INTERVAL_MINUTES, (TimeUnit)TimeUnit.MINUTES);
            LOGGER.info("PipeMetaSyncer is started successfully.");
        }
    }

    private synchronized void sync() {
        TSStatus status = this.configManager.getProcedureManager().pipeMetaSync();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("PipeMetaSyncer meets error in syncing pipe meta, code: {}, message: {}", (Object)status.getCode(), (Object)status.getMessage());
        }
    }

    public synchronized void stop() {
        if (this.metaSyncFuture != null) {
            this.metaSyncFuture.cancel(false);
            this.metaSyncFuture = null;
            LOGGER.info("PipeMetaSyncer is stopped successfully.");
        }
    }
}

