/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.task;

import java.io.IOException;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.read.pipe.task.ShowPipePlanV2;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskCoordinator.class);
    private final ConfigManager configManager;
    private final PipeTaskInfo pipeTaskInfo;

    public PipeTaskCoordinator(ConfigManager configManager, PipeTaskInfo pipeTaskInfo) {
        this.configManager = configManager;
        this.pipeTaskInfo = pipeTaskInfo;
    }

    public PipeTaskInfo getPipeTaskInfo() {
        return this.pipeTaskInfo;
    }

    public void lock() {
        this.pipeTaskInfo.acquirePipeTaskInfoLock();
    }

    public void unlock() {
        this.pipeTaskInfo.releasePipeTaskInfoLock();
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        return this.configManager.getProcedureManager().createPipe(req);
    }

    public TSStatus startPipe(String pipeName) {
        return this.configManager.getProcedureManager().startPipe(pipeName);
    }

    public TSStatus stopPipe(String pipeName) {
        return this.configManager.getProcedureManager().stopPipe(pipeName);
    }

    public TSStatus dropPipe(String pipeName) {
        boolean isPipeExistedBeforeDrop = this.pipeTaskInfo.isPipeExisted(pipeName);
        TSStatus status = this.configManager.getProcedureManager().dropPipe(pipeName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn(String.format("Failed to drop pipe %s. Result status: %s.", pipeName, status));
        }
        return isPipeExistedBeforeDrop ? status : RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_NOT_EXIST_ERROR, (String)String.format("Failed to drop pipe %s. Failures: %s does not exist.", pipeName, pipeName));
    }

    public TShowPipeResp showPipes(TShowPipeReq req) {
        return ((PipeTableResp)this.configManager.getConsensusManager().read(new ShowPipePlanV2()).getDataset()).filter(req.whereClause, req.pipeName).convertToTShowPipeResp();
    }

    public TGetAllPipeInfoResp getAllPipeInfo() {
        try {
            return ((PipeTableResp)this.configManager.getConsensusManager().read(new ShowPipePlanV2()).getDataset()).convertToTGetAllPipeInfoResp();
        }
        catch (IOException e) {
            LOGGER.error("Fail to get AllPipeInfo", (Throwable)e);
            return new TGetAllPipeInfoResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }
}

