/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetAllSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetAllTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.partition.PathInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.AllTemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateSetInfoResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaQuotaStatistics;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUtil;
import org.apache.iotdb.db.metadata.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final double SCHEMA_REGION_PER_DATA_NODE = CONF.getSchemaRegionPerDataNode();
    private static final double DATA_REGION_PER_DATA_NODE = CONF.getDataRegionPerDataNode();
    private final IManager configManager;
    private final ClusterSchemaInfo clusterSchemaInfo;
    private final ClusterSchemaQuotaStatistics schemaQuotaStatistics;

    public ClusterSchemaManager(IManager configManager, ClusterSchemaInfo clusterSchemaInfo, ClusterSchemaQuotaStatistics schemaQuotaStatistics) {
        this.configManager = configManager;
        this.clusterSchemaInfo = clusterSchemaInfo;
        this.schemaQuotaStatistics = schemaQuotaStatistics;
    }

    public TSStatus setDatabase(DatabaseSchemaPlan databaseSchemaPlan) {
        if (databaseSchemaPlan.getSchema().getName().length() > 64) {
            IllegalPathException illegalPathException = new IllegalPathException(databaseSchemaPlan.getSchema().getName(), "the length of database name shall not exceed 64");
            return RpcUtils.getStatus((int)illegalPathException.getErrorCode(), (String)illegalPathException.getMessage());
        }
        if (this.getPartitionManager().isDatabasePreDeleted(databaseSchemaPlan.getSchema().getName())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)String.format("Some other task is deleting database %s", databaseSchemaPlan.getSchema().getName()));
        }
        try {
            this.clusterSchemaInfo.isDatabaseNameValid(databaseSchemaPlan.getSchema().getName());
        }
        catch (MetadataException metadataException) {
            TSStatus result = metadataException instanceof IllegalPathException ? new TSStatus(TSStatusCode.ILLEGAL_PATH.getStatusCode()) : new TSStatus(TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode());
            result.setMessage(metadataException.getMessage());
            return result;
        }
        TSStatus result = this.getConsensusManager().write(databaseSchemaPlan).getStatus();
        PartitionMetrics.bindDatabasePartitionMetrics((AbstractMetricService)MetricService.getInstance(), this.configManager, databaseSchemaPlan.getSchema().getName());
        this.adjustMaxRegionGroupNum();
        return result;
    }

    public TSStatus alterDatabase(DatabaseSchemaPlan databaseSchemaPlan) {
        TDatabaseSchema databaseSchema = databaseSchemaPlan.getSchema();
        if (!this.isDatabaseExist(databaseSchema.getName())) {
            TSStatus result = new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            result.setMessage("Failed to alter database. The Database " + databaseSchema.getName() + " doesn't exist.");
            return result;
        }
        if (databaseSchema.isSetMinSchemaRegionGroupNum()) {
            int minSchemaRegionGroupNum = this.getMinRegionGroupNum(databaseSchema.getName(), TConsensusGroupType.SchemaRegion);
            if (databaseSchema.getMinSchemaRegionGroupNum() <= minSchemaRegionGroupNum) {
                TSStatus result = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode());
                result.setMessage(String.format("Failed to alter database. The SchemaRegionGroupNum could only be increased. Current SchemaRegionGroupNum: %d, Alter SchemaRegionGroupNum: %d", minSchemaRegionGroupNum, databaseSchema.getMinSchemaRegionGroupNum()));
                return result;
            }
        }
        if (databaseSchema.isSetMinDataRegionGroupNum()) {
            int minDataRegionGroupNum = this.getMinRegionGroupNum(databaseSchema.getName(), TConsensusGroupType.DataRegion);
            if (databaseSchema.getMinDataRegionGroupNum() <= minDataRegionGroupNum) {
                TSStatus result = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode());
                result.setMessage(String.format("Failed to alter database. The DataRegionGroupNum could only be increased. Current DataRegionGroupNum: %d, Alter DataRegionGroupNum: %d", minDataRegionGroupNum, databaseSchema.getMinDataRegionGroupNum()));
                return result;
            }
        }
        return this.getConsensusManager().write(databaseSchemaPlan).getStatus();
    }

    public TSStatus deleteDatabase(DeleteDatabasePlan deleteDatabasePlan) {
        TSStatus result = this.getConsensusManager().write(deleteDatabasePlan).getStatus();
        if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.adjustMaxRegionGroupNum();
        }
        return result;
    }

    public CountDatabaseResp countMatchedDatabases(CountDatabasePlan countDatabasePlan) {
        return (CountDatabaseResp)this.getConsensusManager().read(countDatabasePlan).getDataset();
    }

    public DatabaseSchemaResp getMatchedDatabaseSchema(GetDatabasePlan getStorageGroupPlan) {
        DatabaseSchemaResp resp = (DatabaseSchemaResp)this.getConsensusManager().read(getStorageGroupPlan).getDataset();
        ArrayList<String> preDeletedDatabaseList = new ArrayList<String>();
        for (String database : resp.getSchemaMap().keySet()) {
            if (!this.getPartitionManager().isDatabasePreDeleted(database)) continue;
            preDeletedDatabaseList.add(database);
        }
        for (String preDeletedDatabase : preDeletedDatabaseList) {
            resp.getSchemaMap().remove(preDeletedDatabase);
        }
        return resp;
    }

    public TShowDatabaseResp showDatabase(GetDatabasePlan getStorageGroupPlan) {
        DatabaseSchemaResp databaseSchemaResp = (DatabaseSchemaResp)this.getConsensusManager().read(getStorageGroupPlan).getDataset();
        if (databaseSchemaResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return new TShowDatabaseResp().setStatus(databaseSchemaResp.getStatus());
        }
        ConcurrentHashMap<String, TDatabaseInfo> infoMap = new ConcurrentHashMap<String, TDatabaseInfo>();
        for (TDatabaseSchema databaseSchema : databaseSchemaResp.getSchemaMap().values()) {
            String database = databaseSchema.getName();
            TDatabaseInfo databaseInfo = new TDatabaseInfo();
            databaseInfo.setName(database);
            databaseInfo.setTTL(databaseSchema.getTTL());
            databaseInfo.setSchemaReplicationFactor(databaseSchema.getSchemaReplicationFactor());
            databaseInfo.setDataReplicationFactor(databaseSchema.getDataReplicationFactor());
            databaseInfo.setTimePartitionInterval(databaseSchema.getTimePartitionInterval());
            databaseInfo.setMinSchemaRegionNum(this.getMinRegionGroupNum(database, TConsensusGroupType.SchemaRegion));
            databaseInfo.setMaxSchemaRegionNum(this.getMaxRegionGroupNum(database, TConsensusGroupType.SchemaRegion));
            databaseInfo.setMinDataRegionNum(this.getMinRegionGroupNum(database, TConsensusGroupType.DataRegion));
            databaseInfo.setMaxDataRegionNum(this.getMaxRegionGroupNum(database, TConsensusGroupType.DataRegion));
            try {
                databaseInfo.setSchemaRegionNum(this.getPartitionManager().getRegionGroupCount(database, TConsensusGroupType.SchemaRegion));
                databaseInfo.setDataRegionNum(this.getPartitionManager().getRegionGroupCount(database, TConsensusGroupType.DataRegion));
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("The Database: {} doesn't exist. Maybe it has been pre-deleted.", (Object)databaseSchema.getName());
                continue;
            }
            infoMap.put(database, databaseInfo);
        }
        return new TShowDatabaseResp().setDatabaseInfoMap(infoMap).setStatus(StatusUtils.OK);
    }

    public Map<String, Long> getAllTTLInfo() {
        List<String> databases = this.getDatabaseNames();
        ConcurrentHashMap<String, Long> infoMap = new ConcurrentHashMap<String, Long>();
        for (String database : databases) {
            try {
                infoMap.put(database, this.getTTL(database));
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("Database: {} doesn't exist", databases, (Object)e);
            }
        }
        return infoMap;
    }

    public TSStatus setTTL(SetTTLPlan setTTLPlan) {
        Map<String, TDatabaseSchema> storageSchemaMap = this.clusterSchemaInfo.getMatchedDatabaseSchemasByOneName(setTTLPlan.getDatabasePathPattern());
        if (storageSchemaMap.isEmpty()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.DATABASE_NOT_EXIST, (String)("Path [" + new PartialPath(setTTLPlan.getDatabasePathPattern()) + "] does not exist"));
        }
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        ConcurrentHashMap<Integer, List> dnlToSgMap = new ConcurrentHashMap<Integer, List>();
        for (String storageGroup : storageSchemaMap.keySet()) {
            Set<TDataNodeLocation> dataNodeLocations = this.getPartitionManager().getDatabaseRelatedDataNodes(storageGroup, TConsensusGroupType.DataRegion);
            for (TDataNodeLocation dataNodeLocation : dataNodeLocations) {
                dataNodeLocationMap.putIfAbsent(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                dnlToSgMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> new ArrayList()).add(storageGroup);
            }
        }
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.SET_TTL);
        dnlToSgMap.keySet().forEach(dataNodeId -> {
            TSetTTLReq setTTLReq = new TSetTTLReq((List)dnlToSgMap.get(dataNodeId), setTTLPlan.getTTL());
            clientHandler.putRequest((int)dataNodeId, setTTLReq);
            clientHandler.putDataNodeLocation((int)dataNodeId, (TDataNodeLocation)dataNodeLocationMap.get(dataNodeId));
        });
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return this.getConsensusManager().write(setTTLPlan).getStatus();
    }

    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan setSchemaReplicationFactorPlan) {
        return this.getConsensusManager().write(setSchemaReplicationFactorPlan).getStatus();
    }

    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan setDataReplicationFactorPlan) {
        return this.getConsensusManager().write(setDataReplicationFactorPlan).getStatus();
    }

    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan setTimePartitionIntervalPlan) {
        return this.getConsensusManager().write(setTimePartitionIntervalPlan).getStatus();
    }

    public synchronized void adjustMaxRegionGroupNum() {
        Map<String, TDatabaseSchema> databaseSchemaMap = this.getMatchedDatabaseSchemasByName(this.getDatabaseNames());
        if (databaseSchemaMap.size() == 0) {
            return;
        }
        int dataNodeNum = this.getNodeManager().getRegisteredDataNodeCount();
        int databaseNum = databaseSchemaMap.size();
        for (TDatabaseSchema databaseSchema : databaseSchemaMap.values()) {
            if (this.isDatabaseExist(databaseSchema.getName()) && !databaseSchema.getName().equals("root.__system")) continue;
            --databaseNum;
        }
        AdjustMaxRegionGroupNumPlan adjustMaxRegionGroupNumPlan = new AdjustMaxRegionGroupNumPlan();
        for (TDatabaseSchema databaseSchema : databaseSchemaMap.values()) {
            if (databaseSchema.getName().equals("root.__system")) continue;
            try {
                int allocatedSchemaRegionGroupCount;
                try {
                    allocatedSchemaRegionGroupCount = this.getPartitionManager().getRegionGroupCount(databaseSchema.getName(), TConsensusGroupType.SchemaRegion);
                }
                catch (DatabaseNotExistsException e) {
                    continue;
                }
                int maxSchemaRegionGroupNum = ClusterSchemaManager.calcMaxRegionGroupNum(databaseSchema.getMinSchemaRegionGroupNum(), SCHEMA_REGION_PER_DATA_NODE, dataNodeNum, databaseNum, databaseSchema.getSchemaReplicationFactor(), allocatedSchemaRegionGroupCount);
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)databaseSchema.getName(), (Object)maxSchemaRegionGroupNum);
                int allocatedDataRegionGroupCount = this.getPartitionManager().getRegionGroupCount(databaseSchema.getName(), TConsensusGroupType.DataRegion);
                int maxDataRegionGroupNum = ClusterSchemaManager.calcMaxRegionGroupNum(databaseSchema.getMinDataRegionGroupNum(), DATA_REGION_PER_DATA_NODE, dataNodeNum, databaseNum, databaseSchema.getDataReplicationFactor(), allocatedDataRegionGroupCount);
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)databaseSchema.getName(), (Object)maxDataRegionGroupNum);
                adjustMaxRegionGroupNumPlan.putEntry(databaseSchema.getName(), (Pair<Integer, Integer>)new Pair((Object)maxSchemaRegionGroupNum, (Object)maxDataRegionGroupNum));
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("Adjust maxRegionGroupNum failed because StorageGroup doesn't exist", (Throwable)e);
            }
        }
        this.getConsensusManager().write(adjustMaxRegionGroupNumPlan);
    }

    public static int calcMaxRegionGroupNum(int minRegionGroupNum, double resourceWeight, int resource, int databaseNum, int replicationFactor, int allocatedRegionGroupCount) {
        return Math.max(minRegionGroupNum, Math.max((int)Math.ceil(resourceWeight * (double)resource / (double)(databaseNum * replicationFactor)), allocatedRegionGroupCount));
    }

    public boolean isDatabaseExist(String database) {
        return this.getPartitionManager().isDatabaseExist(database);
    }

    public List<String> getDatabaseNames() {
        return this.clusterSchemaInfo.getDatabaseNames().stream().filter(this::isDatabaseExist).collect(Collectors.toList());
    }

    public TDatabaseSchema getDatabaseSchemaByName(String database) throws DatabaseNotExistsException {
        if (!this.isDatabaseExist(database)) {
            throw new DatabaseNotExistsException(database);
        }
        return this.clusterSchemaInfo.getMatchedDatabaseSchemaByName(database);
    }

    public String getDatabaseNameByDevice(String devicePath) {
        List<String> databases = this.getDatabaseNames();
        for (String database : databases) {
            if (!PathUtils.isStartWith((String)devicePath, (String)database)) continue;
            return database;
        }
        return "";
    }

    public Map<String, TDatabaseSchema> getMatchedDatabaseSchemasByName(List<String> rawPathList) {
        ConcurrentHashMap<String, TDatabaseSchema> result = new ConcurrentHashMap<String, TDatabaseSchema>();
        this.clusterSchemaInfo.getMatchedDatabaseSchemasByName(rawPathList).forEach((database, databaseSchema) -> {
            if (this.isDatabaseExist((String)database)) {
                result.put((String)database, (TDatabaseSchema)databaseSchema);
            }
        });
        return result;
    }

    public long getTTL(String database) throws DatabaseNotExistsException {
        return this.getDatabaseSchemaByName(database).getTTL();
    }

    public int getReplicationFactor(String database, TConsensusGroupType consensusGroupType) throws DatabaseNotExistsException {
        TDatabaseSchema storageGroupSchema = this.getDatabaseSchemaByName(database);
        return TConsensusGroupType.SchemaRegion.equals((Object)consensusGroupType) ? storageGroupSchema.getSchemaReplicationFactor() : storageGroupSchema.getDataReplicationFactor();
    }

    public int getMinRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        return this.clusterSchemaInfo.getMinRegionGroupNum(database, consensusGroupType);
    }

    public int getMaxRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        return this.clusterSchemaInfo.getMaxRegionGroupNum(database, consensusGroupType);
    }

    public TSStatus createTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan) {
        return this.getConsensusManager().write(createSchemaTemplatePlan).getStatus();
    }

    public TGetAllTemplatesResp getAllTemplates() {
        GetAllSchemaTemplatePlan getAllSchemaTemplatePlan = new GetAllSchemaTemplatePlan();
        TemplateInfoResp templateResp = (TemplateInfoResp)this.getConsensusManager().read(getAllSchemaTemplatePlan).getDataset();
        TGetAllTemplatesResp resp = new TGetAllTemplatesResp();
        resp.setStatus(templateResp.getStatus());
        if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && templateResp.getTemplateList() != null) {
            ArrayList list = new ArrayList();
            templateResp.getTemplateList().forEach(template -> list.add(template.serialize()));
            resp.setTemplateList(list);
        }
        return resp;
    }

    public TGetTemplateResp getTemplate(String req) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(req);
        TemplateInfoResp templateResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        TGetTemplateResp resp = new TGetTemplateResp();
        if (templateResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && templateResp.getTemplateList() != null && !templateResp.getTemplateList().isEmpty()) {
            ByteBuffer byteBuffer = templateResp.getTemplateList().get(0).serialize();
            resp.setTemplate(byteBuffer);
        }
        resp.setStatus(templateResp.getStatus());
        return resp;
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(String templateName) {
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName);
        PathInfoResp pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan).getDataset();
        if (pathInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            TGetPathsSetTemplatesResp resp = new TGetPathsSetTemplatesResp();
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            resp.setPathList(pathInfoResp.getPathList());
            return resp;
        }
        return new TGetPathsSetTemplatesResp(pathInfoResp.getStatus());
    }

    public byte[] getAllTemplateSetInfo() {
        AllTemplateSetInfoResp resp = (AllTemplateSetInfoResp)this.getConsensusManager().read(new GetAllTemplateSetInfoPlan()).getDataset();
        return resp.getTemplateInfo();
    }

    public TemplateSetInfoResp getTemplateSetInfo(List<PartialPath> patternList) {
        return (TemplateSetInfoResp)this.getConsensusManager().read(new GetTemplateSetInfoPlan(patternList)).getDataset();
    }

    public Pair<TSStatus, Template> checkIsTemplateSetOnPath(String templateName, String path) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(templateName);
        TemplateInfoResp templateResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        if (templateResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (templateResp.getTemplateList() == null || templateResp.getTemplateList().isEmpty()) {
                return new Pair((Object)RpcUtils.getStatus((int)TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), (String)String.format("Undefined template name: %s", templateName)), null);
            }
        } else {
            return new Pair((Object)templateResp.getStatus(), null);
        }
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName);
        PathInfoResp pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan).getDataset();
        if (pathInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<String> templateSetPathList = pathInfoResp.getPathList();
            if (templateSetPathList == null || templateSetPathList.isEmpty() || !pathInfoResp.getPathList().contains(path)) {
                return new Pair((Object)RpcUtils.getStatus((int)TSStatusCode.TEMPLATE_NOT_SET.getStatusCode(), (String)String.format("No template on %s", path)), null);
            }
            return new Pair((Object)templateResp.getStatus(), (Object)templateResp.getTemplateList().get(0));
        }
        return new Pair((Object)pathInfoResp.getStatus(), null);
    }

    public TSStatus preUnsetSchemaTemplate(int templateId, PartialPath path) {
        return this.getConsensusManager().write(new PreUnsetSchemaTemplatePlan(templateId, path)).getStatus();
    }

    public TSStatus rollbackPreUnsetSchemaTemplate(int templateId, PartialPath path) {
        return this.getConsensusManager().write(new RollbackPreUnsetSchemaTemplatePlan(templateId, path)).getStatus();
    }

    public TSStatus unsetSchemaTemplateInBlackList(int templateId, PartialPath path) {
        return this.getConsensusManager().write(new UnsetSchemaTemplatePlan(templateId, path)).getStatus();
    }

    public synchronized TSStatus dropSchemaTemplate(String templateName) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(templateName);
        TemplateInfoResp templateInfoResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        if (templateInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return templateInfoResp.getStatus();
        }
        if (templateInfoResp.getTemplateList() == null || templateInfoResp.getTemplateList().isEmpty()) {
            return RpcUtils.getStatus((int)TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), (String)String.format("Undefined template name: %s", templateName));
        }
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName);
        PathInfoResp pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan).getDataset();
        if (pathInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return pathInfoResp.getStatus();
        }
        if (pathInfoResp.getPathList() != null && !pathInfoResp.getPathList().isEmpty()) {
            return RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)String.format("Template [%s] has been set on MTree, cannot be dropped now.", templateName));
        }
        return this.getConsensusManager().write(new DropSchemaTemplatePlan(templateName)).getStatus();
    }

    public synchronized TSStatus extendSchemaTemplate(TemplateExtendInfo templateExtendInfo) {
        TemplateInfoResp resp;
        if (templateExtendInfo.getEncodings() != null) {
            for (int i = 0; i < templateExtendInfo.getDataTypes().size(); ++i) {
                try {
                    SchemaUtils.checkDataTypeWithEncoding((TSDataType)((TSDataType)templateExtendInfo.getDataTypes().get(i)), (TSEncoding)((TSEncoding)templateExtendInfo.getEncodings().get(i)));
                    continue;
                }
                catch (MetadataException e) {
                    return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
                }
            }
        }
        if ((resp = this.clusterSchemaInfo.getTemplate(new GetSchemaTemplatePlan(templateExtendInfo.getTemplateName()))).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.getStatus();
        }
        Template template = resp.getTemplateList().get(0);
        List intersectionMeasurements = templateExtendInfo.updateAsDifferenceAndGetIntersection(template.getSchemaMap().keySet());
        if (templateExtendInfo.isEmpty()) {
            if (intersectionMeasurements.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE, (String)String.format("Measurement %s already exist in schema template %s", intersectionMeasurements, template.getName()));
        }
        ExtendSchemaTemplatePlan extendSchemaTemplatePlan = new ExtendSchemaTemplatePlan(templateExtendInfo);
        TSStatus status = this.getConsensusManager().write(extendSchemaTemplatePlan).getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        template = this.clusterSchemaInfo.getTemplate(new GetSchemaTemplatePlan(templateExtendInfo.getTemplateName())).getTemplateList().get(0);
        TUpdateTemplateReq updateTemplateReq = new TUpdateTemplateReq();
        updateTemplateReq.setType(TemplateInternalRPCUpdateType.UPDATE_TEMPLATE_INFO.toByte());
        updateTemplateReq.setTemplateInfo(TemplateInternalRPCUtil.generateUpdateTemplateInfoBytes((Template)template));
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TEMPLATE, updateTemplateReq, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.warn("Failed to sync template {} extension info to DataNode {}", (Object)template.getName(), (Object)dataNodeLocationMap.get(entry.getKey()));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("Failed to sync template %s extension info to DataNode %s", template.getName(), dataNodeLocationMap.get(entry.getKey())));
        }
        if (intersectionMeasurements.isEmpty()) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE, (String)String.format("Measurement %s already exist in schema template %s", intersectionMeasurements, template.getName()));
    }

    public long getSchemaQuotaCount() {
        return this.schemaQuotaStatistics.getSchemaQuotaCount(this.getPartitionManager().getAllSchemaPartition());
    }

    public void updateSchemaQuota(Map<Integer, Long> schemaCountMap) {
        this.schemaQuotaStatistics.updateCount(schemaCountMap);
    }

    public void clearSchemaQuotaCache() {
        this.schemaQuotaStatistics.clear();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }
}

