/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.persistence.partition.RegionGroup;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePartitionTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabasePartitionTable.class);
    private volatile boolean preDeleted = false;
    private String databaseName;
    private final Map<TConsensusGroupId, RegionGroup> regionGroupMap;
    private final SchemaPartitionTable schemaPartitionTable;
    private final DataPartitionTable dataPartitionTable;

    public DatabasePartitionTable(String databaseName) {
        this.databaseName = databaseName;
        this.regionGroupMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroup>();
        this.schemaPartitionTable = new SchemaPartitionTable();
        this.dataPartitionTable = new DataPartitionTable();
    }

    public boolean isNotPreDeleted() {
        return !this.preDeleted;
    }

    public void setPreDeleted(boolean preDeleted) {
        this.preDeleted = preDeleted;
    }

    public void createRegionGroups(List<TRegionReplicaSet> replicaSets) {
        replicaSets.forEach(replicaSet -> this.regionGroupMap.put(replicaSet.getRegionId(), new RegionGroup(System.currentTimeMillis(), (TRegionReplicaSet)replicaSet)));
    }

    public void deleteRegionGroups(List<TRegionReplicaSet> replicaSets) {
        replicaSets.forEach(replicaSet -> this.regionGroupMap.remove(replicaSet.getRegionId()));
    }

    public Set<TConsensusGroupId> getAllConsensusGroupId() {
        return this.regionGroupMap.keySet();
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        for (RegionGroup regionGroup : this.regionGroupMap.values()) {
            result.add(regionGroup.getReplicaSet());
        }
        return result;
    }

    public List<TRegionReplicaSet> getAllReplicaSets(TConsensusGroupType type) {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        for (RegionGroup regionGroup : this.regionGroupMap.values()) {
            if (!type.equals((Object)regionGroup.getId().getType())) continue;
            result.add(regionGroup.getReplicaSet());
        }
        return result;
    }

    public List<TRegionReplicaSet> getAllReplicaSets(int dataNodeId) {
        return this.regionGroupMap.values().stream().filter(regionGroup -> regionGroup.belongsToDataNode(dataNodeId)).map(RegionGroup::getReplicaSet).collect(Collectors.toList());
    }

    public List<TRegionReplicaSet> getReplicaSets(List<TConsensusGroupId> regionGroupIds) {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        for (TConsensusGroupId regionGroupId : regionGroupIds) {
            if (!this.regionGroupMap.containsKey(regionGroupId)) continue;
            result.add(this.regionGroupMap.get(regionGroupId).getReplicaSet());
        }
        return result;
    }

    public int getRegionCount(int dataNodeId, TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionGroupMap.values().forEach(regionGroup -> {
            if (type.equals((Object)regionGroup.getId().getType())) {
                regionGroup.getReplicaSet().getDataNodeLocations().forEach(dataNodeLocation -> {
                    if (dataNodeLocation.getDataNodeId() == dataNodeId) {
                        result.getAndIncrement();
                    }
                });
            }
        });
        return result.get();
    }

    public int getRegionGroupCount(TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionGroupMap.values().forEach(regionGroup -> {
            if (regionGroup.getId().getType().equals((Object)type)) {
                result.getAndIncrement();
            }
        });
        return result.getAndIncrement();
    }

    public int getAssignedSeriesPartitionSlotsCount() {
        return Math.max(this.schemaPartitionTable.getSchemaPartitionMap().size(), this.dataPartitionTable.getDataPartitionMap().size());
    }

    public boolean getSchemaPartition(List<TSeriesPartitionSlot> partitionSlots, SchemaPartitionTable schemaPartition) {
        return this.schemaPartitionTable.getSchemaPartition(partitionSlots, schemaPartition);
    }

    public boolean getDataPartition(Map<TSeriesPartitionSlot, TTimeSlotList> partitionSlots, DataPartitionTable dataPartition) {
        return this.dataPartitionTable.getDataPartition(partitionSlots, dataPartition);
    }

    public TConsensusGroupId getAdjacentDataPartition(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        return this.dataPartitionTable.getAdjacentDataPartition(seriesPartitionSlot, timePartitionSlot, timePartitionInterval);
    }

    public void createSchemaPartition(SchemaPartitionTable assignedSchemaPartition) {
        Map groupDeltaMap = this.schemaPartitionTable.createSchemaPartition(assignedSchemaPartition);
        groupDeltaMap.forEach((consensusGroupId, deltaMap) -> this.regionGroupMap.get(consensusGroupId).updateSlotCountMap((Map<TSeriesPartitionSlot, AtomicLong>)deltaMap));
    }

    public void createDataPartition(DataPartitionTable assignedDataPartition) {
        Map groupDeltaMap = this.dataPartitionTable.createDataPartition(assignedDataPartition);
        groupDeltaMap.forEach((consensusGroupId, deltaMap) -> this.regionGroupMap.get(consensusGroupId).updateSlotCountMap((Map<TSeriesPartitionSlot, AtomicLong>)deltaMap));
    }

    public List<TSeriesPartitionSlot> filterUnassignedSchemaPartitionSlots(List<TSeriesPartitionSlot> partitionSlots) {
        return this.schemaPartitionTable.filterUnassignedSchemaPartitionSlots(partitionSlots);
    }

    public Set<TDataNodeLocation> getDatabaseRelatedDataNodes(TConsensusGroupType type) {
        HashSet<TDataNodeLocation> result = new HashSet<TDataNodeLocation>();
        this.regionGroupMap.forEach((consensusGroupId, regionGroup) -> {
            if (consensusGroupId.getType().equals((Object)type)) {
                result.addAll(regionGroup.getReplicaSet().getDataNodeLocations());
            }
        });
        return result;
    }

    public Map<TSeriesPartitionSlot, TTimeSlotList> filterUnassignedDataPartitionSlots(Map<TSeriesPartitionSlot, TTimeSlotList> partitionSlots) {
        return this.dataPartitionTable.filterUnassignedDataPartitionSlots(partitionSlots);
    }

    public List<Pair<Long, TConsensusGroupId>> getRegionGroupSlotsCounter(TConsensusGroupType type) {
        Vector<Pair<Long, TConsensusGroupId>> result = new Vector<Pair<Long, TConsensusGroupId>>();
        this.regionGroupMap.forEach((consensusGroupId, regionGroup) -> {
            if (type.equals((Object)consensusGroupId.getType())) {
                long slotCount = type.equals((Object)TConsensusGroupType.SchemaRegion) ? (long)regionGroup.getSeriesSlotCount() : regionGroup.getTimeSlotCount();
                result.add(new Pair((Object)slotCount, consensusGroupId));
            }
        });
        return result;
    }

    public List<TRegionInfo> getRegionInfoList(GetRegionInfoListPlan regionsInfoPlan) {
        Vector<TRegionInfo> regionInfoList = new Vector<TRegionInfo>();
        TShowRegionReq showRegionReq = regionsInfoPlan.getShowRegionReq();
        this.regionGroupMap.forEach((consensusGroupId, regionGroup) -> {
            if (showRegionReq == null || showRegionReq.getConsensusGroupType() == null || showRegionReq.getConsensusGroupType().equals((Object)regionGroup.getId().getType())) {
                regionInfoList.addAll(this.buildRegionInfoList((RegionGroup)regionGroup));
            }
        });
        return regionInfoList;
    }

    private List<TRegionInfo> buildRegionInfoList(RegionGroup regionGroup) {
        Vector<TRegionInfo> regionInfoList = new Vector<TRegionInfo>();
        TConsensusGroupId regionId = regionGroup.getId();
        regionGroup.getReplicaSet().getDataNodeLocations().forEach(dataNodeLocation -> {
            TRegionInfo regionInfo = new TRegionInfo();
            regionInfo.setConsensusGroupId(regionId);
            regionInfo.setDatabase(this.databaseName);
            regionInfo.setSeriesSlots(regionGroup.getSeriesSlotCount());
            regionInfo.setTimeSlots(regionGroup.getTimeSlotCount());
            regionInfo.setDataNodeId(dataNodeLocation.getDataNodeId());
            regionInfo.setClientRpcIp(dataNodeLocation.getClientRpcEndPoint().getIp());
            regionInfo.setClientRpcPort(dataNodeLocation.getClientRpcEndPoint().getPort());
            regionInfo.setCreateTime(regionGroup.getCreateTime());
            regionInfoList.add(regionInfo);
        });
        return regionInfoList;
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((Boolean)this.preDeleted, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.databaseName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.regionGroupMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TConsensusGroupId, RegionGroup> regionInfoEntry : this.regionGroupMap.entrySet()) {
            regionInfoEntry.getKey().write(protocol);
            regionInfoEntry.getValue().serialize(outputStream, protocol);
        }
        this.schemaPartitionTable.serialize(outputStream, protocol);
        this.dataPartitionTable.serialize(outputStream, protocol);
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        this.preDeleted = ReadWriteIOUtils.readBool((InputStream)inputStream);
        this.databaseName = ReadWriteIOUtils.readString((InputStream)inputStream);
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TConsensusGroupId consensusGroupId = new TConsensusGroupId();
            consensusGroupId.read(protocol);
            RegionGroup regionGroup = new RegionGroup();
            regionGroup.deserialize(inputStream, protocol);
            this.regionGroupMap.put(consensusGroupId, regionGroup);
        }
        this.schemaPartitionTable.deserialize(inputStream, protocol);
        this.dataPartitionTable.deserialize(inputStream, protocol);
    }

    public List<TConsensusGroupId> getRegionId(TConsensusGroupType type, TSeriesPartitionSlot seriesSlotId, TTimePartitionSlot timeSlotId) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.dataPartitionTable.getRegionId(seriesSlotId, timeSlotId);
        }
        if (type == TConsensusGroupType.SchemaRegion) {
            return this.schemaPartitionTable.getRegionId(seriesSlotId);
        }
        return new ArrayList<TConsensusGroupId>();
    }

    public List<TTimePartitionSlot> getTimeSlotList(TSeriesPartitionSlot seriesSlotId, TConsensusGroupId regionId, long startTime, long endTime) {
        return this.dataPartitionTable.getTimeSlotList(seriesSlotId, regionId, startTime, endTime);
    }

    public List<TSeriesPartitionSlot> getSeriesSlotList(TConsensusGroupType type) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.dataPartitionTable.getSeriesSlotList();
        }
        return this.schemaPartitionTable.getSeriesSlotList();
    }

    public void updateRegionLocation(TConsensusGroupId regionId, TDataNodeLocation oldNode, TDataNodeLocation newNode) {
        this.addRegionNewLocation(regionId, newNode);
        this.removeRegionOldLocation(regionId, oldNode);
    }

    private void addRegionNewLocation(TConsensusGroupId regionId, TDataNodeLocation node) {
        RegionGroup regionGroup = this.regionGroupMap.get(regionId);
        if (regionGroup == null) {
            LOGGER.warn("Cannot find RegionGroup for region {} when addRegionNewLocation in {}", (Object)regionId, (Object)this.databaseName);
            return;
        }
        if (regionGroup.getReplicaSet().getDataNodeLocations().contains(node)) {
            LOGGER.info("Node is already in region locations when addRegionNewLocation in {}, node: {}, region: {}", new Object[]{this.databaseName, node, regionId});
            return;
        }
        regionGroup.getReplicaSet().getDataNodeLocations().add(node);
    }

    private void removeRegionOldLocation(TConsensusGroupId regionId, TDataNodeLocation node) {
        RegionGroup regionGroup = this.regionGroupMap.get(regionId);
        if (regionGroup == null) {
            LOGGER.warn("Cannot find RegionGroup for region {} when removeRegionOldLocation in {}", (Object)regionId, (Object)this.databaseName);
            return;
        }
        if (!regionGroup.getReplicaSet().getDataNodeLocations().contains(node)) {
            LOGGER.info("Node is not in region locations when removeRegionOldLocation in {}, no need to remove it, node: {}, region: {}", new Object[]{this.databaseName, node, regionId});
            return;
        }
        regionGroup.getReplicaSet().getDataNodeLocations().remove(node);
    }

    public boolean containRegionGroup(TConsensusGroupId regionId) {
        return this.regionGroupMap.containsKey(regionId);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public List<Integer> getSchemaRegionIds() {
        ArrayList<Integer> schemaRegionIds = new ArrayList<Integer>();
        for (TConsensusGroupId consensusGroupId : this.regionGroupMap.keySet()) {
            if (!consensusGroupId.getType().equals((Object)TConsensusGroupType.SchemaRegion)) continue;
            schemaRegionIds.add(consensusGroupId.getId());
        }
        return schemaRegionIds;
    }

    public List<Integer> getDataRegionIds() {
        ArrayList<Integer> dataRegionIds = new ArrayList<Integer>();
        for (TConsensusGroupId consensusGroupId : this.regionGroupMap.keySet()) {
            if (!consensusGroupId.getType().equals((Object)TConsensusGroupType.DataRegion)) continue;
            dataRegionIds.add(consensusGroupId.getId());
        }
        return dataRegionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabasePartitionTable that = (DatabasePartitionTable)o;
        return this.databaseName.equals(that.databaseName) && this.regionGroupMap.equals(that.regionGroupMap) && this.schemaPartitionTable.equals((Object)that.schemaPartitionTable) && this.dataPartitionTable.equals((Object)that.dataPartitionTable);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.regionGroupMap, this.schemaPartitionTable, this.dataPartitionTable);
    }
}

