/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatePreSetTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatePreSetTable.class);
    private static final String SNAPSHOT_FILENAME = "template_preset_info.bin";
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<Integer, Set<PartialPath>> templatePreSetMap = new ConcurrentHashMap<Integer, Set<PartialPath>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPreSet(int templateId, PartialPath templateSetPath) {
        this.readWriteLock.readLock().lock();
        try {
            Set<PartialPath> templatePreSetPaths = this.templatePreSetMap.get(templateId);
            if (templatePreSetPaths == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = templatePreSetPaths.contains(templateSetPath);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void preSetTemplate(int templateId, PartialPath templateSetPath) {
        this.readWriteLock.writeLock().lock();
        try {
            this.templatePreSetMap.computeIfAbsent(templateId, k -> Collections.synchronizedSet(new HashSet())).add(templateSetPath);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSetTemplate(int templateId, PartialPath templateSetPath) {
        this.readWriteLock.writeLock().lock();
        try {
            Set<PartialPath> set = this.templatePreSetMap.get(templateId);
            if (set == null) {
                boolean bl = false;
                return bl;
            }
            if (set.remove(templateSetPath)) {
                if (set.isEmpty()) {
                    this.templatePreSetMap.remove(templateId);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
            if (!snapshotFile.exists()) {
                return;
            }
            if (!snapshotFile.isFile()) {
                LOGGER.error("Failed to load snapshot of TemplatePreSetTable,snapshot file [{}] is not a valid file.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                this.templatePreSetMap.clear();
                this.deserialize(bufferedInputStream);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.templatePreSetMap.size(), (OutputStream)outputStream);
        for (Map.Entry<Integer, Set<PartialPath>> entry : this.templatePreSetMap.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
            for (PartialPath preSetPath : entry.getValue()) {
                ReadWriteIOUtils.write((String)preSetPath.getFullPath(), (OutputStream)outputStream);
            }
        }
    }

    private void deserialize(InputStream inputStream) throws IOException {
        int templateNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        while (templateNum > 0) {
            --templateNum;
            int templateId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            int preSetPathNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            Set<PartialPath> set = Collections.synchronizedSet(new HashSet());
            while (preSetPathNum > 0) {
                --preSetPathNum;
                try {
                    set.add(new PartialPath(ReadWriteIOUtils.readString((InputStream)inputStream)));
                }
                catch (IllegalPathException illegalPathException) {}
            }
            this.templatePreSetMap.put(templateId, set);
        }
    }
}

