/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.confignode.procedure.exception.ProcedureAbortedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureTimeoutException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.ProcedureState;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Procedure<Env>
implements Comparable<Procedure<Env>> {
    private static final Logger LOG = LoggerFactory.getLogger(Procedure.class);
    public static final long NO_PROC_ID = -1L;
    public static final long NO_TIMEOUT = -1L;
    private long parentProcId = -1L;
    private long rootProcId = -1L;
    private long procId = -1L;
    private long submittedTime;
    private ProcedureState state = ProcedureState.INITIALIZING;
    private int childrenLatch = 0;
    private ProcedureException exception;
    private volatile long timeout = -1L;
    private volatile long lastUpdate;
    private volatile byte[] result = null;
    private volatile boolean locked = false;
    private boolean lockedWhenLoading = false;
    private int[] stackIndexes = null;
    private boolean persist = true;

    public boolean needPersistance() {
        return this.persist;
    }

    public void resetPersistance() {
        this.persist = true;
    }

    public final void skipPersistance() {
        this.persist = false;
    }

    public final boolean hasLock() {
        return this.locked;
    }

    protected abstract Procedure<Env>[] execute(Env var1) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException;

    protected abstract void rollback(Env var1) throws IOException, InterruptedException, ProcedureException;

    protected abstract boolean abort(Env var1);

    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeLong(this.procId);
        stream.writeInt(this.state.ordinal());
        stream.writeLong(this.submittedTime);
        stream.writeLong(this.lastUpdate);
        stream.writeLong(this.parentProcId);
        stream.writeLong(this.timeout);
        if (this.stackIndexes != null) {
            stream.writeInt(this.stackIndexes.length);
            for (int index : this.stackIndexes) {
                stream.writeInt(index);
            }
        } else {
            stream.writeInt(-1);
        }
        if (this.hasException()) {
            stream.write(1);
            String exceptionClassName = this.exception.getClass().getName();
            byte[] exceptionClassNameBytes = exceptionClassName.getBytes(StandardCharsets.UTF_8);
            stream.writeInt(exceptionClassNameBytes.length);
            stream.write(exceptionClassNameBytes);
            String message = this.exception.getMessage();
            if (message != null) {
                byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
                stream.writeInt(messageBytes.length);
                stream.write(messageBytes);
            } else {
                stream.writeInt(-1);
            }
        } else {
            stream.write(0);
        }
        if (this.result != null) {
            stream.writeInt(this.result.length);
            stream.write(this.result);
        } else {
            stream.writeInt(-1);
        }
        stream.write(this.hasLock() ? 1 : 0);
    }

    public void deserialize(ByteBuffer byteBuffer) {
        int resultLen;
        this.setProcId(byteBuffer.getLong());
        this.setState(ProcedureState.values()[byteBuffer.getInt()]);
        this.setSubmittedTime(byteBuffer.getLong());
        this.setLastUpdate(byteBuffer.getLong());
        this.setParentProcId(byteBuffer.getLong());
        this.setTimeout(byteBuffer.getLong());
        int stackIndexesLen = byteBuffer.getInt();
        if (stackIndexesLen >= 0) {
            ArrayList<Integer> indexList = new ArrayList<Integer>(stackIndexesLen);
            for (int i = 0; i < stackIndexesLen; ++i) {
                indexList.add(byteBuffer.getInt());
            }
            this.setStackIndexes(indexList);
        }
        if (byteBuffer.get() == 1) {
            ProcedureException exception;
            Class<?> exceptionClass = Procedure.deserializeTypeInfo(byteBuffer);
            int messageBytesLength = byteBuffer.getInt();
            String errMsg = null;
            if (messageBytesLength > 0) {
                byte[] messageBytes = new byte[messageBytesLength];
                byteBuffer.get(messageBytes);
                errMsg = new String(messageBytes, StandardCharsets.UTF_8);
            }
            try {
                exception = (ProcedureException)exceptionClass.getConstructor(String.class).newInstance(errMsg);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("Instantiation exception class failed", (Throwable)e);
                exception = new ProcedureException(errMsg);
            }
            this.setFailure(exception);
        }
        if ((resultLen = byteBuffer.getInt()) > 0) {
            byte[] resultArr = new byte[resultLen];
            byteBuffer.get(resultArr);
        }
        if (byteBuffer.get() == 1) {
            this.lockedWhenLoading();
        }
    }

    public static Class<?> deserializeTypeInfo(ByteBuffer byteBuffer) {
        Class<?> clazz;
        int classNameBytesLen = byteBuffer.getInt();
        byte[] classNameBytes = new byte[classNameBytesLen];
        byteBuffer.get(classNameBytes);
        String className = new String(classNameBytes, StandardCharsets.UTF_8);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid procedure class", e);
        }
        return clazz;
    }

    public static Procedure<?> newInstance(ByteBuffer byteBuffer) {
        Procedure procedure;
        Class<?> procedureClass = Procedure.deserializeTypeInfo(byteBuffer);
        try {
            procedure = (Procedure)procedureClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Instantiation failed", e);
        }
        return procedure;
    }

    protected boolean waitInitialized(Env env) {
        return false;
    }

    protected ProcedureLockState acquireLock(Env env) {
        return ProcedureLockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(Env env) {
    }

    protected boolean holdLock(Env env) {
        return false;
    }

    protected final void beforeRecover(Env env) {
    }

    protected final void afterRecover(Env env) {
    }

    protected void completionCleanup(Env env) {
    }

    protected boolean isYieldAfterExecution(Env env) {
        return false;
    }

    protected Procedure<Env>[] doExecute(Env env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        try {
            this.updateTimestamp();
            Procedure<Env>[] procedureArray = this.execute(env);
            return procedureArray;
        }
        finally {
            this.updateTimestamp();
        }
    }

    public void doRollback(Env env) throws IOException, InterruptedException, ProcedureException {
        try {
            this.updateTimestamp();
            this.rollback(env);
        }
        finally {
            this.updateTimestamp();
        }
    }

    public final ProcedureLockState doAcquireLock(Env env, IProcedureStore store) {
        if (this.waitInitialized(env)) {
            return ProcedureLockState.LOCK_EVENT_WAIT;
        }
        if (this.lockedWhenLoading) {
            this.lockedWhenLoading = false;
            this.locked = true;
            return ProcedureLockState.LOCK_ACQUIRED;
        }
        ProcedureLockState state = this.acquireLock(env);
        if (state == ProcedureLockState.LOCK_ACQUIRED) {
            this.locked = true;
            store.update(this);
        }
        return state;
    }

    public final void doReleaseLock(Env env, IProcedureStore store) {
        this.locked = false;
        if (this.getState() != ProcedureState.ROLLEDBACK) {
            store.update(this);
        }
        this.releaseLock(env);
    }

    public final void restoreLock(Env env) {
        if (!this.lockedWhenLoading) {
            LOG.debug("{} didn't hold the lock before restarting, skip acquiring lock", (Object)this);
            return;
        }
        if (this.isFinished()) {
            LOG.debug("{} is already bypassed, skip acquiring lock.", (Object)this);
            return;
        }
        if (this.getState() == ProcedureState.WAITING && !this.holdLock(env)) {
            LOG.debug("{} is in WAITING STATE, and holdLock= false , skip acquiring lock.", (Object)this);
            return;
        }
        LOG.debug("{} held the lock before restarting, call acquireLock to restore it.", (Object)this);
        this.acquireLock(env);
    }

    public String toString() {
        return this.toStringSimpleSB().toString();
    }

    protected StringBuilder toStringSimpleSB() {
        StringBuilder sb = new StringBuilder();
        sb.append("pid=");
        sb.append(this.getProcId());
        if (this.hasParent()) {
            sb.append(", ppid=");
            sb.append(this.getParentProcId());
        }
        sb.append(", state=");
        this.toStringState(sb);
        if (this.locked) {
            sb.append(", locked=").append(this.locked);
        }
        if (this.hasException()) {
            sb.append(", exception=" + this.getException());
        }
        sb.append("; ");
        this.toStringClassDetails(sb);
        return sb;
    }

    public String toStringDetails() {
        StringBuilder sb = this.toStringSimpleSB();
        sb.append(" submittedTime=");
        sb.append(this.getSubmittedTime());
        sb.append(", lastUpdate=");
        sb.append(this.getLastUpdate());
        int[] stackIndices = this.getStackIndexes();
        if (stackIndices != null) {
            sb.append("\n");
            sb.append("stackIndexes=");
            sb.append(Arrays.toString(stackIndices));
        }
        return sb.toString();
    }

    protected String toStringClass() {
        StringBuilder sb = new StringBuilder();
        this.toStringClassDetails(sb);
        return sb.toString();
    }

    protected void toStringState(StringBuilder builder) {
        builder.append((Object)this.getState());
    }

    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getClass().getName());
    }

    public long getProcId() {
        return this.procId;
    }

    public boolean hasParent() {
        return this.parentProcId != -1L;
    }

    public long getParentProcId() {
        return this.parentProcId;
    }

    public long getRootProcId() {
        return this.rootProcId;
    }

    public String getProcName() {
        return this.toStringClass();
    }

    public long getSubmittedTime() {
        return this.submittedTime;
    }

    protected void setProcId(long procId) {
        this.procId = procId;
    }

    public void setProcRunnable() {
        this.submittedTime = System.currentTimeMillis();
        this.setState(ProcedureState.RUNNABLE);
    }

    protected void setParentProcId(long parentProcId) {
        this.parentProcId = parentProcId;
    }

    protected void setRootProcId(long rootProcId) {
        this.rootProcId = rootProcId;
    }

    protected void setSubmittedTime(long submittedTime) {
        this.submittedTime = submittedTime;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != -1L;
    }

    public long getTimeout() {
        return this.timeout;
    }

    protected void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    protected void updateTimestamp() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    protected long getTimeoutTimestamp() {
        return this.getLastUpdate() + this.getTimeout();
    }

    public long elapsedTime() {
        return this.getLastUpdate() - this.getSubmittedTime();
    }

    public byte[] getResult() {
        return this.result;
    }

    protected void setResult(byte[] result) {
        this.result = result;
    }

    final void lockedWhenLoading() {
        this.lockedWhenLoading = true;
    }

    public boolean isLockedWhenLoading() {
        return this.lockedWhenLoading;
    }

    public synchronized boolean isRunnable() {
        return this.state == ProcedureState.RUNNABLE;
    }

    public synchronized boolean isInitializing() {
        return this.state == ProcedureState.INITIALIZING;
    }

    public synchronized boolean isFailed() {
        return this.state == ProcedureState.FAILED || this.state == ProcedureState.ROLLEDBACK;
    }

    public synchronized boolean isSuccess() {
        return this.state == ProcedureState.SUCCESS && !this.hasException();
    }

    public synchronized boolean isFinished() {
        return this.isSuccess() || this.state == ProcedureState.ROLLEDBACK;
    }

    public synchronized boolean isWaiting() {
        switch (this.state) {
            case WAITING: 
            case WAITING_TIMEOUT: {
                return true;
            }
        }
        return false;
    }

    protected synchronized void setState(ProcedureState state) {
        this.state = state;
        this.updateTimestamp();
    }

    public synchronized ProcedureState getState() {
        return this.state;
    }

    protected synchronized void setFailure(String source, Throwable cause) {
        this.setFailure(new ProcedureException(source, cause));
    }

    protected synchronized void setFailure(ProcedureException exception) {
        this.exception = exception;
        if (!this.isFinished()) {
            this.setState(ProcedureState.FAILED);
        }
    }

    protected void setAbortFailure(String source, String msg) {
        this.setFailure(source, new ProcedureAbortedException(msg));
    }

    protected synchronized boolean setTimeoutFailure(Env env) {
        if (this.state == ProcedureState.WAITING_TIMEOUT) {
            long timeDiff = System.currentTimeMillis() - this.lastUpdate;
            this.setFailure("ProcedureExecutor", new ProcedureTimeoutException("Operation timed out after " + timeDiff + " ms."));
            return true;
        }
        return false;
    }

    public synchronized boolean hasException() {
        return this.exception != null;
    }

    public synchronized ProcedureException getException() {
        return this.exception;
    }

    protected synchronized void setChildrenLatch(int numChildren) {
        this.childrenLatch = numChildren;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CHILD LATCH INCREMENT SET " + this.childrenLatch, new Throwable(this.toString()));
        }
    }

    protected synchronized void incChildrenLatch() {
        ++this.childrenLatch;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CHILD LATCH INCREMENT " + this.childrenLatch, new Throwable(this.toString()));
        }
    }

    private synchronized boolean childrenCountDown() {
        boolean b;
        assert (this.childrenLatch > 0) : this;
        boolean bl = b = --this.childrenLatch == 0;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CHILD LATCH DECREMENT " + this.childrenLatch, new Throwable(this.toString()));
        }
        return b;
    }

    synchronized boolean tryRunnable() {
        if (this.getState() == ProcedureState.WAITING && this.childrenCountDown()) {
            this.setState(ProcedureState.RUNNABLE);
            return true;
        }
        return false;
    }

    protected synchronized boolean hasChildren() {
        return this.childrenLatch > 0;
    }

    protected synchronized int getChildrenLatch() {
        return this.childrenLatch;
    }

    protected synchronized void addStackIndex(int index) {
        if (this.stackIndexes == null) {
            this.stackIndexes = new int[]{index};
        } else {
            int count = this.stackIndexes.length;
            this.stackIndexes = Arrays.copyOf(this.stackIndexes, count + 1);
            this.stackIndexes[count] = index;
        }
    }

    protected synchronized boolean removeStackIndex() {
        if (this.stackIndexes != null && this.stackIndexes.length > 1) {
            this.stackIndexes = Arrays.copyOf(this.stackIndexes, this.stackIndexes.length - 1);
            return false;
        }
        this.stackIndexes = null;
        return true;
    }

    protected synchronized void setStackIndexes(List<Integer> stackIndexes) {
        this.stackIndexes = new int[stackIndexes.size()];
        for (int i = 0; i < this.stackIndexes.length; ++i) {
            this.stackIndexes[i] = stackIndexes.get(i);
        }
    }

    protected synchronized boolean wasExecuted() {
        return this.stackIndexes != null;
    }

    protected synchronized int[] getStackIndexes() {
        return this.stackIndexes;
    }

    protected static long getRootProcedureId(Map<Long, Procedure> procedures, Procedure proc) {
        while (proc.hasParent()) {
            if ((proc = procedures.get(proc.getParentProcId())) != null) continue;
            return -1L;
        }
        return proc.getProcId();
    }

    public void setRootProcedureId(long rootProcedureId) {
        this.rootProcId = rootProcedureId;
    }

    public static boolean haveSameParent(Procedure<?> a, Procedure<?> b) {
        return a.hasParent() && b.hasParent() && a.getParentProcId() == b.getParentProcId();
    }

    @Override
    public int compareTo(Procedure<Env> other) {
        return Long.compare(this.getProcId(), other.getProcId());
    }
}

