/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.confignode.procedure.InternalProcedure;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.RootProcedureStack;
import org.apache.iotdb.confignode.procedure.StoppableThread;

public class TimeoutExecutorThread<Env>
extends StoppableThread {
    private static final int DELAY_QUEUE_TIMEOUT = 20;
    private final ProcedureExecutor<Env> executor;
    private final DelayQueue<ProcedureDelayContainer<Env>> queue = new DelayQueue();

    public TimeoutExecutorThread(ProcedureExecutor<Env> envProcedureExecutor, ThreadGroup threadGroup, String name) {
        super(threadGroup, name);
        this.setDaemon(true);
        this.executor = envProcedureExecutor;
    }

    public void add(Procedure<Env> procedure) {
        this.queue.add(new ProcedureDelayContainer<Env>(procedure));
    }

    public boolean remove(Procedure<Env> procedure) {
        return this.queue.remove(new ProcedureDelayContainer<Env>(procedure));
    }

    private ProcedureDelayContainer<Env> takeQuietly() {
        try {
            return (ProcedureDelayContainer)this.queue.poll(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            TimeoutExecutorThread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public void run() {
        while (this.executor.isRunning()) {
            ProcedureDelayContainer<Env> delayTask = this.takeQuietly();
            if (delayTask == null) continue;
            Procedure<Env> procedure = delayTask.getProcedure();
            if (procedure instanceof InternalProcedure) {
                InternalProcedure internal = (InternalProcedure)procedure;
                internal.periodicExecute(this.executor.getEnvironment());
                procedure.updateTimestamp();
                this.queue.add(delayTask);
                continue;
            }
            if (!procedure.setTimeoutFailure(this.executor.getEnvironment())) continue;
            long rootProcId = this.executor.getRootProcId(procedure);
            RootProcedureStack<Env> rollbackStack = this.executor.getRollbackStack(rootProcId);
            rollbackStack.abort();
            this.executor.getStore().update(procedure);
            this.executor.getScheduler().addFront(procedure);
        }
    }

    @Override
    public void sendStopSignal() {
    }

    private static class ProcedureDelayContainer<Env>
    implements Delayed {
        private final Procedure<Env> procedure;

        public ProcedureDelayContainer(Procedure<Env> procedure) {
            this.procedure = procedure;
        }

        public Procedure<Env> getProcedure() {
            return this.procedure;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.procedure.getTimeoutTimestamp() - System.currentTimeMillis();
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            return Long.compareUnsigned(this.getDelay(TimeUnit.MILLISECONDS), other.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

