/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.datanode.ConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeToStatusResp;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TSystemConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelInfoReq;
import org.apache.iotdb.confignode.rpc.thrift.TUpdateModelStateReq;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.db.mpp.plan.statement.AuthorType;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRPCServiceProcessor
implements IConfigNodeRPCService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeRPCServiceProcessor.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONFIG = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigManager configManager;

    public ConfigNodeRPCServiceProcessor(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void close() throws IOException {
        this.configManager.close();
    }

    public ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TSystemConfigurationResp getSystemConfiguration() {
        TSystemConfigurationResp resp = ((ConfigurationResp)this.configManager.getSystemConfiguration()).convertToRpcSystemConfigurationResp();
        LOGGER.info("Execute GetSystemConfiguration with result {}", (Object)resp);
        return resp;
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) {
        TDataNodeRegisterResp resp = ((DataNodeRegisterResp)this.configManager.registerDataNode(req)).convertToRpcDataNodeRegisterResp();
        LOGGER.info("Execute RegisterDataNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TDataNodeRestartResp restartDataNode(TDataNodeRestartReq req) {
        TDataNodeRestartResp resp = this.configManager.restartDataNode(req);
        LOGGER.info("Execute RestartDataNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TDataNodeRemoveResp removeDataNode(TDataNodeRemoveReq req) {
        LOGGER.info("ConfigNode RPC Service start to remove DataNode, req: {}", (Object)req);
        RemoveDataNodePlan removeDataNodePlan = new RemoveDataNodePlan(req.getDataNodeLocations());
        DataNodeToStatusResp removeResp = (DataNodeToStatusResp)this.configManager.removeDataNode(removeDataNodePlan);
        TDataNodeRemoveResp resp = removeResp.convertToRpCDataNodeRemoveResp();
        LOGGER.info("ConfigNode RPC Service finished to remove DataNode, req: {}, result: {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus reportDataNodeShutdown(TDataNodeLocation dataNodeLocation) {
        return this.configManager.reportDataNodeShutdown(dataNodeLocation);
    }

    public TDataNodeConfigurationResp getDataNodeConfiguration(int dataNodeID) {
        GetDataNodeConfigurationPlan queryReq = new GetDataNodeConfigurationPlan(dataNodeID);
        DataNodeConfigurationResp queryResp = (DataNodeConfigurationResp)this.configManager.getDataNodeConfiguration(queryReq);
        TDataNodeConfigurationResp resp = new TDataNodeConfigurationResp();
        queryResp.convertToRpcDataNodeLocationResp(resp);
        return resp;
    }

    public TSStatus reportRegionMigrateResult(TRegionMigrateResultReportReq req) {
        return this.configManager.reportRegionMigrateResult(req);
    }

    public TShowClusterResp showCluster() {
        return this.configManager.showCluster();
    }

    public TShowVariablesResp showVariables() {
        return this.configManager.showVariables();
    }

    public TSStatus setDatabase(TDatabaseSchema databaseSchema) {
        TSStatus errorResp = null;
        boolean isSystemDatabase = databaseSchema.getName().equals("root.__system");
        if (!databaseSchema.isSetTTL()) {
            databaseSchema.setTTL(CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
        } else if (databaseSchema.getTTL() <= 0L) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The TTL should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setSchemaReplicationFactor(1);
        } else if (!databaseSchema.isSetSchemaReplicationFactor()) {
            databaseSchema.setSchemaReplicationFactor(CONFIG_NODE_CONFIG.getSchemaReplicationFactor());
        } else if (databaseSchema.getSchemaReplicationFactor() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The schemaReplicationFactor should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setDataReplicationFactor(1);
        } else if (!databaseSchema.isSetDataReplicationFactor()) {
            databaseSchema.setDataReplicationFactor(CONFIG_NODE_CONFIG.getDataReplicationFactor());
        } else if (databaseSchema.getDataReplicationFactor() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The dataReplicationFactor should be positive.");
        }
        if (!databaseSchema.isSetTimePartitionInterval()) {
            databaseSchema.setTimePartitionInterval(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval());
        } else if (databaseSchema.getTimePartitionInterval() <= 0L) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The timePartitionInterval should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setMinSchemaRegionGroupNum(1);
        } else if (!databaseSchema.isSetMinSchemaRegionGroupNum()) {
            databaseSchema.setMinSchemaRegionGroupNum(CONFIG_NODE_CONFIG.getDefaultSchemaRegionGroupNumPerDatabase());
        } else if (databaseSchema.getMinSchemaRegionGroupNum() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The schemaRegionGroupNum should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setMinDataRegionGroupNum(1);
        } else if (!databaseSchema.isSetMinDataRegionGroupNum()) {
            databaseSchema.setMinDataRegionGroupNum(CONFIG_NODE_CONFIG.getDefaultDataRegionGroupNumPerDatabase());
        } else if (databaseSchema.getMinDataRegionGroupNum() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The dataRegionGroupNum should be positive.");
        }
        if (errorResp != null) {
            LOGGER.warn("Execute SetDatabase: {} with result: {}", (Object)databaseSchema, (Object)errorResp);
            return errorResp;
        }
        databaseSchema.setMaxSchemaRegionGroupNum(databaseSchema.getMinSchemaRegionGroupNum());
        databaseSchema.setMaxDataRegionGroupNum(databaseSchema.getMinDataRegionGroupNum());
        DatabaseSchemaPlan setPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, databaseSchema);
        TSStatus resp = this.configManager.setDatabase(setPlan);
        LOGGER.info("Execute SetDatabase: {} with result: {}", (Object)databaseSchema, (Object)resp);
        return resp;
    }

    public TSStatus alterDatabase(TDatabaseSchema databaseSchema) {
        TSStatus errorResp = null;
        if (databaseSchema.isSetTTL()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER TTL yet.");
        }
        if (databaseSchema.isSetSchemaReplicationFactor()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER SchemaReplicationFactor yet.");
        }
        if (databaseSchema.isSetDataReplicationFactor()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER DataReplicationFactor yet.");
        }
        if (databaseSchema.isSetTimePartitionInterval()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER TimePartitionInterval yet.");
        }
        if (errorResp != null) {
            LOGGER.warn("Execute AlterDatabase: {} with result: {}", (Object)databaseSchema, (Object)errorResp);
            return errorResp;
        }
        DatabaseSchemaPlan alterPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.AlterDatabase, databaseSchema);
        TSStatus resp = this.configManager.alterDatabase(alterPlan);
        LOGGER.info("Execute AlterDatabase: {} with result: {}", (Object)databaseSchema, (Object)resp);
        return resp;
    }

    public TSStatus deleteDatabase(TDeleteDatabaseReq tDeleteReq) {
        String prefixPath = tDeleteReq.getPrefixPath();
        return this.configManager.deleteDatabases(Collections.singletonList(prefixPath));
    }

    public TSStatus deleteDatabases(TDeleteDatabasesReq tDeleteReq) {
        List prefixList = tDeleteReq.getPrefixPathList();
        return this.configManager.deleteDatabases(prefixList);
    }

    public TSStatus setTTL(TSetTTLReq req) throws TException {
        return this.configManager.setTTL(new SetTTLPlan(req.getStorageGroupPathPattern(), req.getTTL()));
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        return this.configManager.setSchemaReplicationFactor(new SetSchemaReplicationFactorPlan(req.getDatabase(), req.getSchemaReplicationFactor()));
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        return this.configManager.setDataReplicationFactor(new SetDataReplicationFactorPlan(req.getDatabase(), req.getDataReplicationFactor()));
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        return this.configManager.setTimePartitionInterval(new SetTimePartitionIntervalPlan(req.getDatabase(), req.getTimePartitionInterval()));
    }

    public TCountDatabaseResp countMatchedDatabases(List<String> storageGroupPathPattern) {
        CountDatabaseResp countDatabaseResp = (CountDatabaseResp)this.configManager.countMatchedDatabases(new CountDatabasePlan(storageGroupPathPattern));
        TCountDatabaseResp resp = new TCountDatabaseResp();
        countDatabaseResp.convertToRPCCountStorageGroupResp(resp);
        return resp;
    }

    public TDatabaseSchemaResp getMatchedDatabaseSchemas(List<String> storageGroupPathPattern) {
        DatabaseSchemaResp databaseSchemaResp = (DatabaseSchemaResp)this.configManager.getMatchedDatabaseSchemas(new GetDatabasePlan(storageGroupPathPattern));
        return databaseSchemaResp.convertToRPCStorageGroupSchemaResp();
    }

    public TSchemaPartitionTableResp getSchemaPartitionTable(TSchemaPartitionReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getSchemaPartition(patternTree);
    }

    public TSchemaPartitionTableResp getOrCreateSchemaPartitionTable(TSchemaPartitionReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getOrCreateSchemaPartition(patternTree);
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        PartialPath partialPath = (PartialPath)patternTree.getAllPathPatterns().get(0);
        return this.configManager.getNodePathsPartition(partialPath, req.getLevel());
    }

    public TDataPartitionTableResp getDataPartitionTable(TDataPartitionReq req) {
        GetDataPartitionPlan getDataPartitionPlan = GetDataPartitionPlan.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getDataPartition(getDataPartitionPlan);
    }

    public TDataPartitionTableResp getOrCreateDataPartitionTable(TDataPartitionReq req) {
        GetOrCreateDataPartitionPlan getOrCreateDataPartitionReq = GetOrCreateDataPartitionPlan.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
    }

    public TSStatus operatePermission(TAuthorizerReq req) {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        AuthorPlan plan = null;
        try {
            plan = new AuthorPlan(ConfigPhysicalPlanType.values()[req.getAuthorType() + ConfigPhysicalPlanType.Author.ordinal() + 1], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getNodeNameList())));
        }
        catch (AuthException e) {
            LOGGER.error(e.getMessage());
        }
        return this.configManager.operatePermission(plan);
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        AuthorPlan plan = null;
        try {
            plan = new AuthorPlan(ConfigPhysicalPlanType.values()[req.getAuthorType() + ConfigPhysicalPlanType.Author.ordinal() + 1], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getNodeNameList())));
        }
        catch (AuthException e) {
            LOGGER.error(e.getMessage());
        }
        PermissionInfoResp dataSet = (PermissionInfoResp)this.configManager.queryPermission(plan);
        TAuthorizerResp resp = new TAuthorizerResp(dataSet.getStatus());
        resp.setAuthorizerInfo(dataSet.getPermissionInfo());
        return resp;
    }

    public TPermissionInfoResp login(TLoginReq req) {
        return this.configManager.login(req.getUserrname(), req.getPassword());
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) {
        List partialPaths = AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getPaths()));
        return this.configManager.checkUserPrivileges(req.getUsername(), partialPaths, req.getPermission());
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        TConfigNodeRegisterResp resp = this.configManager.registerConfigNode(req);
        LOGGER.info("Execute RegisterConfigNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus addConsensusGroup(TAddConsensusGroupReq registerResp) {
        return this.configManager.createPeerForConsensusGroup(registerResp.getConfigNodeList());
    }

    public TSStatus notifyRegisterSuccess() {
        try {
            SystemPropertiesUtils.storeSystemParameters();
        }
        catch (IOException e) {
            LOGGER.error("Write confignode-system.properties failed", (Throwable)e);
            return new TSStatus(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode());
        }
        LOGGER.info("{} has successfully started and joined the cluster: {}.", (Object)"IoTDB-ConfigNode", (Object)ConfigNodeDescriptor.getInstance().getConf().getClusterName());
        return StatusUtils.OK;
    }

    public TSStatus restartConfigNode(TConfigNodeRestartReq req) {
        TSStatus status = this.configManager.restartConfigNode(req);
        LOGGER.info("Execute RestartConfigNodeRequest {} with result {}", (Object)req, (Object)status);
        return status;
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        RemoveConfigNodePlan removeConfigNodePlan = new RemoveConfigNodePlan(configNodeLocation);
        TSStatus status = this.configManager.removeConfigNode(removeConfigNodePlan);
        LOGGER.info("Execute RemoveConfigNodeRequest {} with result {}", (Object)configNodeLocation, (Object)status);
        return status;
    }

    public TSStatus deleteConfigNodePeer(TConfigNodeLocation configNodeLocation) {
        if (!this.configManager.getNodeManager().getRegisteredConfigNodes().contains(configNodeLocation)) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("remove ConsensusGroup failed because the ConfigNode not in current Cluster.");
        }
        ConsensusGroupId groupId = this.configManager.getConsensusManager().getConsensusGroupId();
        ConsensusGenericResponse resp = this.configManager.getConsensusManager().getConsensusImpl().deletePeer(groupId);
        if (!resp.isSuccess()) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("remove ConsensusGroup failed because internal failure. See other logs for more details");
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("remove ConsensusGroup success.");
    }

    public TSStatus reportConfigNodeShutdown(TConfigNodeLocation configNodeLocation) {
        return this.configManager.reportConfigNodeShutdown(configNodeLocation);
    }

    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) {
        new Thread(() -> {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn(e.getMessage());
            }
            finally {
                ConfigNode.getInstance().stop();
            }
        }).start();
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Stop ConfigNode success.");
    }

    public TSStatus createFunction(TCreateFunctionReq req) {
        return this.configManager.createFunction(req);
    }

    public TSStatus dropFunction(TDropFunctionReq req) {
        return this.configManager.dropFunction(req.getUdfName());
    }

    public TGetUDFTableResp getUDFTable() {
        return this.configManager.getUDFTable();
    }

    public TGetJarInListResp getUDFJar(TGetJarInListReq req) {
        return this.configManager.getUDFJar(req);
    }

    public TSStatus createTrigger(TCreateTriggerReq req) {
        return this.configManager.createTrigger(req);
    }

    public TSStatus dropTrigger(TDropTriggerReq req) {
        return this.configManager.dropTrigger(req);
    }

    public TGetTriggerTableResp getTriggerTable() {
        return this.configManager.getTriggerTable();
    }

    public TGetTriggerTableResp getStatefulTriggerTable() {
        return this.configManager.getStatefulTriggerTable();
    }

    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) {
        return this.configManager.getLocationOfStatefulTrigger(triggerName);
    }

    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) {
        return this.configManager.getTriggerJar(req);
    }

    public TSStatus createPipePlugin(TCreatePipePluginReq req) {
        return this.configManager.createPipePlugin(req);
    }

    public TSStatus dropPipePlugin(TDropPipePluginReq req) {
        return this.configManager.dropPipePlugin(req.getPluginName());
    }

    public TGetPipePluginTableResp getPipePluginTable() {
        return this.configManager.getPipePluginTable();
    }

    public TGetJarInListResp getPipePluginJar(TGetJarInListReq req) {
        return this.configManager.getPipePluginJar(req);
    }

    public TSStatus merge() throws TException {
        return this.configManager.merge();
    }

    public TSStatus flush(TFlushReq req) throws TException {
        List<PartialPath> noExistSg;
        if (req.storageGroups != null && !(noExistSg = this.configManager.getPartitionManager().filterUnExistDatabases(PartialPath.fromStringList((List)req.storageGroups))).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.DATABASE_NOT_EXIST, (String)("storageGroup " + sb.subSequence(0, sb.length() - 1) + " does not exist"));
        }
        return this.configManager.flush(req);
    }

    public TSStatus clearCache() {
        return this.configManager.clearCache();
    }

    public TSStatus loadConfiguration() {
        return this.configManager.loadConfiguration();
    }

    public TSStatus setSystemStatus(String status) {
        return this.configManager.setSystemStatus(status);
    }

    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq req) {
        return this.configManager.setDataNodeStatus(req);
    }

    public TSStatus killQuery(String queryId, int dataNodeId) {
        return this.configManager.killQuery(queryId, dataNodeId);
    }

    public TGetDataNodeLocationsResp getRunningDataNodeLocations() {
        return this.configManager.getRunningDataNodeLocations();
    }

    public TShowRegionResp showRegion(TShowRegionReq showRegionReq) {
        GetRegionInfoListPlan getRegionInfoListPlan = new GetRegionInfoListPlan(showRegionReq);
        RegionInfoListResp dataSet = this.configManager.showRegion(getRegionInfoListPlan);
        TShowRegionResp showRegionResp = new TShowRegionResp();
        showRegionResp.setStatus(dataSet.getStatus());
        showRegionResp.setRegionInfoList(dataSet.getRegionInfoList());
        return showRegionResp;
    }

    public TRegionRouteMapResp getLatestRegionRouteMap() {
        return this.configManager.getLatestRegionRouteMap();
    }

    public long getConfigNodeHeartBeat(long timestamp) {
        return timestamp;
    }

    public TShowDataNodesResp showDataNodes() {
        return this.configManager.showDataNodes();
    }

    public TShowConfigNodesResp showConfigNodes() {
        return this.configManager.showConfigNodes();
    }

    public TShowDatabaseResp showDatabase(List<String> storageGroupPathPattern) {
        return this.configManager.showDatabase(new GetDatabasePlan(storageGroupPathPattern));
    }

    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) {
        return this.configManager.createSchemaTemplate(req);
    }

    public TGetAllTemplatesResp getAllTemplates() {
        return this.configManager.getAllTemplates();
    }

    public TGetTemplateResp getTemplate(String req) {
        return this.configManager.getTemplate(req);
    }

    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) {
        return this.configManager.setSchemaTemplate(req);
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(String req) {
        return this.configManager.getPathsSetTemplate(req);
    }

    public TSStatus deactivateSchemaTemplate(TDeactivateSchemaTemplateReq req) {
        return this.configManager.deactivateSchemaTemplate(req);
    }

    public TSStatus unsetSchemaTemplate(TUnsetSchemaTemplateReq req) {
        return this.configManager.unsetSchemaTemplate(req);
    }

    public TSStatus dropSchemaTemplate(String req) {
        return this.configManager.dropSchemaTemplate(req);
    }

    public TSStatus alterSchemaTemplate(TAlterSchemaTemplateReq req) throws TException {
        return this.configManager.alterSchemaTemplate(req);
    }

    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        return this.configManager.deleteTimeSeries(req);
    }

    public TSStatus deleteLogicalView(TDeleteLogicalViewReq req) {
        return this.configManager.deleteLogicalView(req);
    }

    public TSStatus alterLogicalView(TAlterLogicalViewReq req) throws TException {
        return this.configManager.alterLogicalView(req);
    }

    @Deprecated
    public TSStatus createPipeSink(TPipeSinkInfo req) {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @Deprecated
    public TSStatus dropPipeSink(TDropPipeSinkReq req) {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @Deprecated
    public TGetPipeSinkResp getPipeSink(TGetPipeSinkReq req) {
        return new TGetPipeSinkResp();
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        return this.configManager.createPipe(req);
    }

    public TSStatus startPipe(String pipeName) {
        return this.configManager.startPipe(pipeName);
    }

    public TSStatus stopPipe(String pipeName) {
        return this.configManager.stopPipe(pipeName);
    }

    public TSStatus dropPipe(String pipeName) {
        return this.configManager.dropPipe(pipeName);
    }

    public TShowPipeResp showPipe(TShowPipeReq req) {
        return this.configManager.showPipe(req);
    }

    public TGetAllPipeInfoResp getAllPipeInfo() {
        return this.configManager.getAllPipeInfo();
    }

    public TGetRegionIdResp getRegionId(TGetRegionIdReq req) {
        if (req.isSetTimeStamp() && req.getType() != TConsensusGroupType.DataRegion) {
            TSStatus status = new TSStatus(TSStatusCode.ILLEGAL_PARAMETER.getStatusCode());
            status.setMessage("Only data region can set time");
            return new TGetRegionIdResp(status);
        }
        return this.configManager.getRegionId(req);
    }

    public TGetTimeSlotListResp getTimeSlotList(TGetTimeSlotListReq req) {
        return this.configManager.getTimeSlotList(req);
    }

    public TCountTimeSlotListResp countTimeSlotList(TCountTimeSlotListReq req) {
        return this.configManager.countTimeSlotList(req);
    }

    public TGetSeriesSlotListResp getSeriesSlotList(TGetSeriesSlotListReq req) {
        return this.configManager.getSeriesSlotList(req);
    }

    public TSStatus migrateRegion(TMigrateRegionReq req) {
        return this.configManager.migrateRegion(req);
    }

    public TSStatus createCQ(TCreateCQReq req) {
        return this.configManager.createCQ(req);
    }

    public TSStatus dropCQ(TDropCQReq req) {
        return this.configManager.dropCQ(req);
    }

    public TShowCQResp showCQ() {
        return this.configManager.showCQ();
    }

    public TSStatus createModel(TCreateModelReq req) {
        return this.configManager.createModel(req);
    }

    public TSStatus dropModel(TDropModelReq req) {
        return this.configManager.dropModel(req);
    }

    public TShowModelResp showModel(TShowModelReq req) {
        return this.configManager.showModel(req);
    }

    public TShowTrailResp showTrail(TShowTrailReq req) {
        return this.configManager.showTrail(req);
    }

    public TSStatus updateModelInfo(TUpdateModelInfoReq req) {
        return this.configManager.updateModelInfo(req);
    }

    public TSStatus updateModelState(TUpdateModelStateReq req) {
        return this.configManager.updateModelState(req);
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) throws TException {
        return this.configManager.setSpaceQuota(req);
    }

    public TSpaceQuotaResp showSpaceQuota(List<String> databases) {
        return this.configManager.showSpaceQuota(databases);
    }

    public TSpaceQuotaResp getSpaceQuota() {
        return this.configManager.getSpaceQuota();
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) throws TException {
        return this.configManager.setThrottleQuota(req);
    }

    public TThrottleQuotaResp showThrottleQuota(TShowThrottleReq req) {
        return this.configManager.showThrottleQuota(req);
    }

    public TThrottleQuotaResp getThrottleQuota() {
        return this.configManager.getThrottleQuota();
    }
}

