/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.property;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class ClientPoolProperty<V> {
    private final GenericKeyedObjectPoolConfig<V> config;

    private ClientPoolProperty(GenericKeyedObjectPoolConfig<V> config) {
        this.config = config;
    }

    public GenericKeyedObjectPoolConfig<V> getConfig() {
        return this.config;
    }

    public static class DefaultProperty {
        public static final long WAIT_CLIENT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
        public static final int MAX_CLIENT_NUM_FOR_EACH_NODE = 300;
        public static final int CORE_CLIENT_NUM_FOR_EACH_NODE = 200;

        private DefaultProperty() {
        }
    }

    public static class Builder<V> {
        private long waitClientTimeoutMs = DefaultProperty.WAIT_CLIENT_TIMEOUT_MS;
        private int maxClientNumForEachNode = 300;
        private int coreClientNumForEachNode = 200;

        public Builder<V> setWaitClientTimeoutMs(long waitClientTimeoutMs) {
            this.waitClientTimeoutMs = waitClientTimeoutMs;
            return this;
        }

        public Builder<V> setMaxClientNumForEachNode(int maxClientNumForEachNode) {
            this.maxClientNumForEachNode = maxClientNumForEachNode;
            return this;
        }

        public Builder<V> setCoreClientNumForEachNode(int coreClientNumForEachNode) {
            this.coreClientNumForEachNode = coreClientNumForEachNode;
            return this;
        }

        public ClientPoolProperty<V> build() {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMaxTotalPerKey(this.maxClientNumForEachNode);
            poolConfig.setMaxIdlePerKey(this.coreClientNumForEachNode);
            poolConfig.setMaxWait(Duration.ofMillis(this.waitClientTimeoutMs));
            poolConfig.setTestOnReturn(true);
            poolConfig.setTestOnBorrow(true);
            return new ClientPoolProperty(poolConfig);
        }
    }
}

