/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeExceptionType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTaskMeta {
    private final AtomicReference<ProgressIndex> progressIndex = new AtomicReference();
    private final AtomicInteger leaderDataNodeId = new AtomicInteger(0);
    private final Queue<PipeRuntimeException> exceptionMessages = new ConcurrentLinkedQueue<PipeRuntimeException>();

    public PipeTaskMeta(ProgressIndex progressIndex, int leaderDataNodeId) {
        this.progressIndex.set(progressIndex);
        this.leaderDataNodeId.set(leaderDataNodeId);
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex.get();
    }

    public ProgressIndex updateProgressIndex(ProgressIndex updateIndex) {
        return this.progressIndex.updateAndGet(index -> index.updateToMinimumIsAfterProgressIndex(updateIndex));
    }

    public int getLeaderDataNodeId() {
        return this.leaderDataNodeId.get();
    }

    public void setLeaderDataNodeId(int leaderDataNodeId) {
        this.leaderDataNodeId.set(leaderDataNodeId);
    }

    public Iterable<PipeRuntimeException> getExceptionMessages() {
        return this.exceptionMessages;
    }

    public void trackExceptionMessage(PipeRuntimeException exceptionMessage) {
        this.exceptionMessages.add(exceptionMessage);
    }

    public void clearExceptionMessages() {
        this.exceptionMessages.clear();
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        this.progressIndex.get().serialize(outputStream);
        ReadWriteIOUtils.write((int)this.leaderDataNodeId.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.exceptionMessages.size(), (OutputStream)outputStream);
        for (PipeRuntimeException pipeRuntimeException : this.exceptionMessages) {
            pipeRuntimeException.serialize(outputStream);
        }
    }

    public void serialize(FileOutputStream outputStream) throws IOException {
        this.progressIndex.get().serialize(outputStream);
        ReadWriteIOUtils.write((int)this.leaderDataNodeId.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.exceptionMessages.size(), (OutputStream)outputStream);
        for (PipeRuntimeException pipeRuntimeException : this.exceptionMessages) {
            pipeRuntimeException.serialize(outputStream);
        }
    }

    public static PipeTaskMeta deserialize(ByteBuffer byteBuffer) {
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
        int leaderDataNodeId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PipeTaskMeta PipeTaskMeta2 = new PipeTaskMeta(progressIndex, leaderDataNodeId);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            PipeRuntimeException pipeRuntimeException = PipeRuntimeExceptionType.deserializeFrom(byteBuffer);
            PipeTaskMeta2.exceptionMessages.add(pipeRuntimeException);
        }
        return PipeTaskMeta2;
    }

    public static PipeTaskMeta deserialize(InputStream inputStream) throws IOException {
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(inputStream);
        int leaderDataNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
        PipeTaskMeta PipeTaskMeta2 = new PipeTaskMeta(progressIndex, leaderDataNodeId);
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            PipeRuntimeException pipeRuntimeException = PipeRuntimeExceptionType.deserializeFrom(inputStream);
            PipeTaskMeta2.exceptionMessages.add(pipeRuntimeException);
        }
        return PipeTaskMeta2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTaskMeta that = (PipeTaskMeta)obj;
        return this.progressIndex.get().equals(that.progressIndex.get()) && this.leaderDataNodeId.get() == that.leaderDataNodeId.get() && Arrays.equals(this.exceptionMessages.toArray(), that.exceptionMessages.toArray());
    }

    public int hashCode() {
        return Objects.hash(this.progressIndex, this.leaderDataNodeId, this.exceptionMessages);
    }

    public String toString() {
        return "PipeTask{progressIndex='" + this.progressIndex + '\'' + ", leaderDataNodeId='" + this.leaderDataNodeId + '\'' + ", exceptionMessages=" + this.exceptionMessages + '}';
    }
}

