/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsensusFactory {
    public static final String CONSTRUCT_FAILED_MSG = "Construct consensusImpl failed, Please check your consensus className %s";
    public static final String SIMPLE_CONSENSUS = "org.apache.iotdb.consensus.simple.SimpleConsensus";
    public static final String RATIS_CONSENSUS = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    public static final String IOT_CONSENSUS = "org.apache.iotdb.consensus.iot.IoTConsensus";
    private static final Logger logger = LoggerFactory.getLogger(ConsensusFactory.class);

    public static Optional<IConsensus> getConsensusImpl(String className, ConsensusConfig config, IStateMachine.Registry registry) {
        try {
            Class<?> executor = Class.forName(className);
            Constructor<?> executorConstructor = executor.getDeclaredConstructor(ConsensusConfig.class, IStateMachine.Registry.class);
            executorConstructor.setAccessible(true);
            return Optional.of((IConsensus)executorConstructor.newInstance(config, registry));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Couldn't Construct IConsensus class: {}", (Object)className, (Object)e);
            return Optional.empty();
        }
    }
}

