/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.client;

import java.io.IOException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.consensus.iot.thrift.IoTConsensusIService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncIoTConsensusServiceClient
extends IoTConsensusIService.AsyncClient
implements ThriftClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncIoTConsensusServiceClient.class);
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncIoTConsensusServiceClient> clientManager;

    public AsyncIoTConsensusServiceClient(ThriftClientProperty property, TEndPoint endpoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncIoTConsensusServiceClient> clientManager) throws IOException {
        super(property.getProtocolFactory(), tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)property.getConnectionTimeoutMs()));
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException((Throwable)e, (ThriftClient)this);
        this.returnSelf();
    }

    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception("This client has been invalidated"));
        }
    }

    public void invalidateAll() {
        this.clientManager.clear((Object)this.endpoint);
    }

    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    private void returnSelf() {
        this.clientManager.returnClient((Object)this.endpoint, (Object)this);
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            logger.info("Unexpected exception occurs in {} :", (Object)this, (Object)e);
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncConfigNodeIServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncIoTConsensusServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncIoTConsensusServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncIoTConsensusServiceClient> pooledObject) {
            ((AsyncIoTConsensusServiceClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<AsyncIoTConsensusServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncIoTConsensusServiceClient(this.thriftClientProperty, endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], (ClientManager<TEndPoint, AsyncIoTConsensusServiceClient>)this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncIoTConsensusServiceClient> pooledObject) {
            return ((AsyncIoTConsensusServiceClient)((Object)pooledObject.getObject())).isReady();
        }
    }
}

