/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.factory.BaseClientFactory;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RatisClient {
    private final Logger logger = LoggerFactory.getLogger(RatisClient.class);
    private final RaftGroup serveGroup;
    private final RaftClient raftClient;
    private final ClientManager<RaftGroup, RatisClient> clientManager;

    RatisClient(RaftGroup serveGroup, RaftClient client, ClientManager<RaftGroup, RatisClient> clientManager) {
        this.serveGroup = serveGroup;
        this.raftClient = client;
        this.clientManager = clientManager;
    }

    RaftClient getRaftClient() {
        return this.raftClient;
    }

    private void close() {
        try {
            this.raftClient.close();
        }
        catch (IOException e) {
            this.logger.warn("cannot close raft client ", (Throwable)e);
        }
    }

    void returnSelf() {
        this.clientManager.returnClient((Object)this.serveGroup, (Object)this);
    }

    private static class RatisRetryPolicy
    implements RetryPolicy {
        private static final Logger logger = LoggerFactory.getLogger(RatisClient.class);
        private final RetryPolicy defaultPolicy;

        RatisRetryPolicy(RatisConfig.Client config) {
            this.defaultPolicy = ExponentialBackoffRetry.newBuilder().setBaseSleepTime(TimeDuration.valueOf((long)config.getClientRetryInitialSleepTimeMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setMaxSleepTime(TimeDuration.valueOf((long)config.getClientRetryMaxSleepTimeMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setMaxAttempts(config.getClientMaxRetryAttempt()).build();
        }

        public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
            Optional<Throwable> unexpectedCause = Optional.ofNullable(event.getCause()).filter(t -> t instanceof RaftException).map(Throwable::getCause).filter(t -> t instanceof StatusRuntimeException);
            if (unexpectedCause.isPresent()) {
                logger.info("{}: raft client request failed and caught exception: ", (Object)this, (Object)unexpectedCause.get());
                return NO_RETRY_ACTION;
            }
            return this.defaultPolicy.handleAttemptFailure(event);
        }
    }

    static class Factory
    extends BaseClientFactory<RaftGroup, RatisClient> {
        private final RaftProperties raftProperties;
        private final RaftClientRpc clientRpc;
        private final RatisConfig.Client config;

        public Factory(ClientManager<RaftGroup, RatisClient> clientManager, RaftProperties raftProperties, RaftClientRpc clientRpc, RatisConfig.Client config) {
            super(clientManager);
            this.raftProperties = raftProperties;
            this.clientRpc = clientRpc;
            this.config = config;
        }

        public void destroyObject(RaftGroup key, PooledObject<RatisClient> pooledObject) {
            ((RatisClient)pooledObject.getObject()).close();
        }

        public PooledObject<RatisClient> makeObject(RaftGroup group) {
            return new DefaultPooledObject((Object)new RatisClient(group, RaftClient.newBuilder().setProperties(this.raftProperties).setRaftGroup(group).setRetryPolicy((RetryPolicy)new RatisRetryPolicy(this.config)).setClientRpc(this.clientRpc).build(), (ClientManager<RaftGroup, RatisClient>)this.clientManager));
        }

        public boolean validateObject(RaftGroup key, PooledObject<RatisClient> pooledObject) {
            return true;
        }
    }
}

