/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.consensus.ratis.metrics.CounterProxy;
import org.apache.iotdb.consensus.ratis.metrics.GaugeProxy;
import org.apache.iotdb.consensus.ratis.metrics.TimerProxy;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;

public class IoTDBMetricRegistry
implements RatisMetricRegistry {
    private final AbstractMetricService metricService;
    private final MetricRegistryInfo info;
    private final String prefix;
    private final Map<String, String> metricNameCache = new ConcurrentHashMap<String, String>();
    private final Map<String, CounterProxy> counterCache = new ConcurrentHashMap<String, CounterProxy>();
    private final Map<String, TimerProxy> timerCache = new ConcurrentHashMap<String, TimerProxy>();
    private final Map<String, GaugeProxy> gaugeCache = new ConcurrentHashMap<String, GaugeProxy>();
    public static final String RAFT_LOG_FLUSH_TIME = "flushTime";
    public static final String RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES = "closedSegmentsSizeInBytes";
    public static final String RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES = "openSegmentSizeInBytes";
    public static final String RAFT_LOG_APPEND_ENTRY_LATENCY = "appendEntryLatency";
    public static final String RAFT_LOG_TASK_ENQUEUE_DELAY = "queueingDelay";
    public static final String RAFT_LOG_TASK_QUEUE_TIME = "enqueuedTime";
    public static final String RAFT_LOG_TASK_EXECUTION_TIME = "ExecutionTime";
    public static final String FOLLOWER_APPEND_ENTRIES_LATENCY = "follower_append_entry_latency";
    public static final String RAFT_CLIENT_WRITE_REQUEST = "clientWriteRequest";
    private static final List<String> RATIS_METRICS = new ArrayList<String>();

    IoTDBMetricRegistry(MetricRegistryInfo info, AbstractMetricService service) {
        this.info = info;
        this.metricService = service;
        this.prefix = MetricRegistry.name((String)Utils.getConsensusGroupTypeFromPrefix(info.getPrefix()).toString(), (String[])new String[]{info.getApplicationName(), info.getMetricsComponentName()});
    }

    private String getMetricName(String name) {
        return this.metricNameCache.computeIfAbsent(name, n -> MetricRegistry.name((String)this.prefix, (String[])new String[]{n}));
    }

    public MetricLevel getMetricLevel(String name) {
        for (String ratisMetric : RATIS_METRICS) {
            if (!name.contains(ratisMetric)) continue;
            return MetricLevel.IMPORTANT;
        }
        return MetricLevel.CORE;
    }

    public Timer timer(String name) {
        String fullName = this.getMetricName(name);
        return this.timerCache.computeIfAbsent(fullName, fn -> new TimerProxy(this.metricService.getOrCreateTimer(fn, this.getMetricLevel(fullName), new String[0])));
    }

    public Counter counter(String name) {
        String fullName = this.getMetricName(name);
        return this.counterCache.computeIfAbsent(fullName, fn -> new CounterProxy(this.metricService.getOrCreateCounter(this.getMetricName(name), this.getMetricLevel(fullName), new String[0])));
    }

    public boolean remove(String name) {
        try {
            this.metricService.remove(MetricType.COUNTER, this.getMetricName(name), new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metricService.remove(MetricType.TIMER, this.getMetricName(name), new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metricService.remove(MetricType.AUTO_GAUGE, this.getMetricName(name), new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    void removeAll() {
        this.counterCache.forEach((name, counter) -> this.metricService.remove(MetricType.COUNTER, name, new String[0]));
        this.gaugeCache.forEach((name, gauge) -> this.metricService.remove(MetricType.AUTO_GAUGE, name, new String[0]));
        this.timerCache.forEach((name, timer) -> this.metricService.remove(MetricType.TIMER, name, new String[0]));
        this.metricNameCache.clear();
        this.counterCache.clear();
        this.gaugeCache.clear();
        this.timerCache.clear();
    }

    public Gauge gauge(String name, MetricRegistry.MetricSupplier<Gauge> metricSupplier) {
        String fullName = this.getMetricName(name);
        return this.gaugeCache.computeIfAbsent(fullName, gaugeName -> {
            GaugeProxy gauge = new GaugeProxy(metricSupplier);
            this.metricService.createAutoGauge(gaugeName, this.getMetricLevel(fullName), (Object)gauge, GaugeProxy::getValueAsDouble, new String[0]);
            return gauge;
        });
    }

    public Timer timer(String name, MetricRegistry.MetricSupplier<Timer> metricSupplier) {
        throw new UnsupportedOperationException("This method is not used in IoTDB project");
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter metricFilter) {
        throw new UnsupportedOperationException("This method is not used in IoTDB project");
    }

    public Counter counter(String name, MetricRegistry.MetricSupplier<Counter> metricSupplier) {
        throw new UnsupportedOperationException("This method is not used in IoTDB project");
    }

    public Histogram histogram(String name) {
        throw new UnsupportedOperationException("Histogram is not used in Ratis Metrics");
    }

    public Meter meter(String name) {
        throw new UnsupportedOperationException("Meter is not used in Ratis Metrics");
    }

    public Meter meter(String name, MetricRegistry.MetricSupplier<Meter> metricSupplier) {
        throw new UnsupportedOperationException("Meter is not used in Ratis Metrics");
    }

    public Metric get(String name) {
        throw new UnsupportedOperationException("Meter is not used in Ratis Metrics");
    }

    public <T extends Metric> T register(String name, T t) throws IllegalArgumentException {
        throw new UnsupportedOperationException("register is not used in Ratis Metrics");
    }

    public MetricRegistry getDropWizardMetricRegistry() {
        throw new UnsupportedOperationException("This method is not used in IoTDB project");
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }

    public void registerAll(String s, MetricSet metricSet) {
        throw new UnsupportedOperationException("registerAll is not used in Ratis Metrics");
    }

    public void setJmxReporter(JmxReporter jmxReporter) {
        throw new UnsupportedOperationException("JmxReporter is not used in Ratis Metrics");
    }

    public JmxReporter getJmxReporter() {
        throw new UnsupportedOperationException("JmxReporter is not used in Ratis Metrics");
    }

    public void setConsoleReporter(ConsoleReporter consoleReporter) {
        throw new UnsupportedOperationException("ConsoleReporter is not used in Ratis Metrics");
    }

    public ConsoleReporter getConsoleReporter() {
        throw new UnsupportedOperationException("ConsoleReporter is not used in Ratis Metrics");
    }

    static {
        RATIS_METRICS.add(RAFT_LOG_FLUSH_TIME);
        RATIS_METRICS.add(RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES);
        RATIS_METRICS.add(RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES);
        RATIS_METRICS.add(RAFT_LOG_APPEND_ENTRY_LATENCY);
        RATIS_METRICS.add(RAFT_LOG_TASK_ENQUEUE_DELAY);
        RATIS_METRICS.add(RAFT_LOG_TASK_QUEUE_TIME);
        RATIS_METRICS.add(RAFT_LOG_TASK_EXECUTION_TIME);
        RATIS_METRICS.add(FOLLOWER_APPEND_ENTRIES_LATENCY);
        RATIS_METRICS.add(RAFT_CLIENT_WRITE_REQUEST);
    }
}

