/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UnorderedAsync {
    public static final Logger LOG = LoggerFactory.getLogger(UnorderedAsync.class);

    public static CompletableFuture<RaftClientReply> send(RaftClientRequest.Type type, Message message, RaftPeerId server, RaftClientImpl client) {
        long callId = CallId.getAndIncrement();
        PendingUnorderedRequest pending = new PendingUnorderedRequest(() -> client.newRaftClientRequest(server, callId, message, type, null));
        UnorderedAsync.sendRequestWithRetry(pending, client);
        return pending.getReplyFuture().thenApply(reply -> RaftClientImpl.handleRaftException(reply, CompletionException::new));
    }

    public static void sendRequestWithRetry(RaftClientImpl.PendingClientRequest pending, RaftClientImpl client) {
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        RaftClientRequest request = pending.newRequest();
        int attemptCount = pending.getAttemptCount();
        ClientId clientId = client.getId();
        LOG.debug("{}: attempt #{} send~ {}", new Object[]{clientId, attemptCount, request});
        client.getClientRpc().sendRequestAsyncUnordered(request).whenCompleteAsync((reply, e) -> {
            try {
                LOG.debug("{}: attempt #{} receive~ {}", new Object[]{clientId, attemptCount, reply});
                RaftException replyException = reply != null ? reply.getException() : null;
                reply = client.handleLeaderException(request, (RaftClientReply)reply);
                if (reply != null) {
                    client.handleReply(request, (RaftClientReply)reply);
                    f.complete((RaftClientReply)reply);
                    return;
                }
                Object cause = replyException != null ? replyException : e;
                pending.incrementExceptionCount((Throwable)cause);
                ClientRetryEvent event = new ClientRetryEvent(request, (Throwable)cause, pending);
                RetryPolicy retryPolicy = client.getRetryPolicy();
                RetryPolicy.Action action = retryPolicy.handleAttemptFailure((RetryPolicy.Event)event);
                TimeDuration sleepTime = client.getEffectiveSleepTime((Throwable)cause, action.getSleepTime());
                if (!action.shouldRetry()) {
                    f.completeExceptionally(client.noMoreRetries(event));
                    return;
                }
                if (e != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(clientId + ": attempt #" + attemptCount + " failed~ " + request, e);
                    } else {
                        LOG.debug("{}: attempt #{} failed {} with {}", new Object[]{clientId, attemptCount, request, e});
                    }
                    e = JavaUtils.unwrapCompletionException((Throwable)e);
                    if (e instanceof IOException) {
                        if (e instanceof NotLeaderException) {
                            client.handleNotLeaderException(request, (NotLeaderException)e, null);
                        } else {
                            if (e instanceof GroupMismatchException) {
                                f.completeExceptionally((Throwable)e);
                                return;
                            }
                            client.handleIOException(request, (IOException)e);
                        }
                    } else if (!client.getClientRpc().handleException(request.getServerId(), (Throwable)e, false)) {
                        f.completeExceptionally((Throwable)e);
                        return;
                    }
                }
                LOG.debug("schedule retry for attempt #{}, policy={}, request={}", new Object[]{attemptCount, retryPolicy, request});
                client.getScheduler().onTimeout(sleepTime, () -> UnorderedAsync.sendRequestWithRetry(pending, client), LOG, () -> clientId + ": Failed~ to retry " + request);
            }
            catch (Exception ex) {
                LOG.error(clientId + ": Failed " + request, (Throwable)ex);
                f.completeExceptionally(ex);
            }
        });
    }

    public static class PendingUnorderedRequest
    extends RaftClientImpl.PendingClientRequest {
        private final Supplier<RaftClientRequest> requestConstructor;

        PendingUnorderedRequest(Supplier<RaftClientRequest> requestConstructor) {
            this.requestConstructor = requestConstructor;
        }

        @Override
        public RaftClientRequest newRequestImpl() {
            return this.requestConstructor.get();
        }
    }
}

