/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class JvmCompileMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        CompilationMXBean compilationBean = ManagementFactory.getCompilationMXBean();
        if (compilationBean != null && compilationBean.isCompilationTimeMonitoringSupported()) {
            metricService.createAutoGauge("jvm_compilation_time_ms", MetricLevel.IMPORTANT, compilationBean, CompilationMXBean::getTotalCompilationTime, "compiler", compilationBean.getName());
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        CompilationMXBean compilationBean = ManagementFactory.getCompilationMXBean();
        if (compilationBean != null && compilationBean.isCompilationTimeMonitoringSupported()) {
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_compilation_time_ms", "compiler", compilationBean.getName());
        }
    }
}

