/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.net.INetMetricManager;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxNetMetricManager
implements INetMetricManager {
    private final Logger log = LoggerFactory.getLogger(LinuxNetMetricManager.class);
    private static final String IFACE_ID_PATH = "/sys/class/net/";
    private static final String NET_STATUS_PATH = "/proc/net/dev";
    private static final String BYTES = "bytes";
    private static final String PACKETS = "packets";
    private static final int IFACE_NAME_INDEX = 0;
    private static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private int receivedBytesIndex = 0;
    private int transmittedBytesIndex = 0;
    private int receivedPacketsIndex = 0;
    private int transmittedPacketsIndex = 0;
    private int connectionNum = 0;
    private final String[] getConnectNumCmd;
    private Set<String> ifaceSet;
    private final Map<String, Long> receivedBytesMapForIface;
    private final Map<String, Long> transmittedBytesMapForIface;
    private final Map<String, Long> receivedPacketsMapForIface;
    private final Map<String, Long> transmittedPacketsMapForIface;
    private long lastUpdateTime = 0L;

    public LinuxNetMetricManager() {
        this.collectIfaces();
        this.receivedBytesMapForIface = new HashMap<String, Long>(this.ifaceSet.size() + 1, 1.0f);
        this.transmittedBytesMapForIface = new HashMap<String, Long>(this.ifaceSet.size() + 1, 1.0f);
        this.receivedPacketsMapForIface = new HashMap<String, Long>(this.ifaceSet.size() + 1, 1.0f);
        this.transmittedPacketsMapForIface = new HashMap<String, Long>(this.ifaceSet.size() + 1, 1.0f);
        this.collectNetStatusIndex();
        this.getConnectNumCmd = new String[]{"/bin/sh", "-c", String.format("ls -l /proc/%s/fd | grep socket: | wc -l", METRIC_CONFIG.getPid())};
    }

    @Override
    public Set<String> getIfaceSet() {
        this.checkUpdate();
        return this.ifaceSet;
    }

    @Override
    public Map<String, Long> getReceivedByte() {
        this.checkUpdate();
        return this.receivedBytesMapForIface;
    }

    @Override
    public Map<String, Long> getTransmittedBytes() {
        this.checkUpdate();
        return this.transmittedBytesMapForIface;
    }

    @Override
    public Map<String, Long> getReceivedPackets() {
        this.checkUpdate();
        return this.receivedPacketsMapForIface;
    }

    @Override
    public Map<String, Long> getTransmittedPackets() {
        this.checkUpdate();
        return this.transmittedPacketsMapForIface;
    }

    @Override
    public int getConnectionNum() {
        return this.connectionNum;
    }

    private void checkUpdate() {
        if (System.currentTimeMillis() - this.lastUpdateTime >= 10000L) {
            this.updateNetStatus();
        }
    }

    private void collectIfaces() {
        File ifaceIdFolder = new File(IFACE_ID_PATH);
        if (!ifaceIdFolder.exists()) {
            this.ifaceSet = Collections.emptySet();
            this.log.warn("Cannot find {}", (Object)IFACE_ID_PATH);
            return;
        }
        this.ifaceSet = new ArrayList<File>(Arrays.asList(Objects.requireNonNull(ifaceIdFolder.listFiles()))).stream().map(File::getName).collect(Collectors.toSet());
    }

    private void collectNetStatusIndex() {
        File netStatusFile = new File(NET_STATUS_PATH);
        if (!netStatusFile.exists()) {
            this.log.warn("Cannot find {}", (Object)NET_STATUS_PATH);
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(netStatusFile);){
            int i;
            Scanner scanner = new Scanner(inputStream);
            scanner.nextLine();
            String headerLine = scanner.nextLine();
            String[] seperatedHeaderLine = headerLine.split("\\|");
            String[] receiveStatusHeader = seperatedHeaderLine[1].split("\\s+");
            String[] transmitStatusHeader = seperatedHeaderLine[2].split("\\s+");
            int length = receiveStatusHeader.length;
            for (i = 0; i < length; ++i) {
                if (receiveStatusHeader[i].equals(BYTES)) {
                    this.receivedBytesIndex = i + 1;
                    continue;
                }
                if (!receiveStatusHeader[i].equals(PACKETS)) continue;
                this.receivedPacketsIndex = i + 1;
            }
            length = transmitStatusHeader.length;
            for (i = 0; i < length; ++i) {
                if (transmitStatusHeader[i].equals(BYTES)) {
                    this.transmittedBytesIndex = i + length + 1;
                    continue;
                }
                if (!transmitStatusHeader[i].equals(PACKETS)) continue;
                this.transmittedPacketsIndex = i + length + 1;
            }
        }
        catch (IOException e) {
            this.log.error("Meets exception when reading {}", (Object)NET_STATUS_PATH, (Object)e);
        }
    }

    private void updateNetStatus() {
        this.lastUpdateTime = System.currentTimeMillis();
        File netStatusFile = new File(NET_STATUS_PATH);
        if (!netStatusFile.exists()) {
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(netStatusFile);){
            Scanner scanner = new Scanner(inputStream);
            scanner.nextLine();
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                ArrayList<String> statusInfoAsList = new ArrayList<String>(Arrays.asList(line.split("\\s")));
                statusInfoAsList.removeIf(x -> x.equals(""));
                String iface = (String)statusInfoAsList.get(0);
                iface = iface.substring(0, iface.length() - 1);
                long receivedBytes = Long.parseLong((String)statusInfoAsList.get(this.receivedBytesIndex));
                this.receivedBytesMapForIface.put(iface, receivedBytes);
                long transmittedBytes = Long.parseLong((String)statusInfoAsList.get(this.transmittedBytesIndex));
                this.transmittedBytesMapForIface.put(iface, transmittedBytes);
                long receivedPackets = Long.parseLong((String)statusInfoAsList.get(this.receivedPacketsIndex));
                this.receivedPacketsMapForIface.put(iface, receivedPackets);
                long transmittedPackets = Long.parseLong((String)statusInfoAsList.get(this.transmittedPacketsIndex));
                this.transmittedPacketsMapForIface.put(iface, transmittedPackets);
            }
        }
        catch (IOException e) {
            this.log.error("Meets error when reading {} for net status", (Object)NET_STATUS_PATH, (Object)e);
        }
        if (MetricLevel.higherOrEqual(MetricLevel.NORMAL, METRIC_CONFIG.getMetricLevel())) {
            try {
                Process process = Runtime.getRuntime().exec(this.getConnectNumCmd);
                StringBuilder result = new StringBuilder();
                try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                    }
                }
                this.connectionNum = Integer.parseInt(result.toString().trim());
            }
            catch (IOException e) {
                this.log.error("Failed to get socket num", (Throwable)e);
            }
        }
    }
}

