/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.authorizer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;

public interface IAuthorizer
extends SnapshotProcessor {
    public boolean login(String var1, String var2) throws AuthException;

    public void createUser(String var1, String var2) throws AuthException;

    public void deleteUser(String var1) throws AuthException;

    public void grantPrivilegeToUser(String var1, PartialPath var2, int var3) throws AuthException;

    public void revokePrivilegeFromUser(String var1, PartialPath var2, int var3) throws AuthException;

    public void createRole(String var1) throws AuthException;

    public void deleteRole(String var1) throws AuthException;

    public void grantPrivilegeToRole(String var1, PartialPath var2, int var3) throws AuthException;

    public void revokePrivilegeFromRole(String var1, PartialPath var2, int var3) throws AuthException;

    public void grantRoleToUser(String var1, String var2) throws AuthException;

    public void revokeRoleFromUser(String var1, String var2) throws AuthException;

    public Set<Integer> getPrivileges(String var1, PartialPath var2) throws AuthException;

    public void updateUserPassword(String var1, String var2) throws AuthException;

    public boolean checkUserPrivileges(String var1, PartialPath var2, int var3) throws AuthException;

    public void reset() throws AuthException;

    public List<String> listAllUsers();

    public List<String> listAllRoles();

    public Role getRole(String var1) throws AuthException;

    public User getUser(String var1) throws AuthException;

    public boolean isUserUseWaterMark(String var1) throws AuthException;

    public void setUserUseWaterMark(String var1, boolean var2) throws AuthException;

    public Map<String, Boolean> getAllUserWaterMarkStatus();

    public Map<String, User> getAllUsers();

    public Map<String, Role> getAllRoles();

    public void replaceAllUsers(Map<String, User> var1) throws AuthException;

    public void replaceAllRoles(Map<String, Role> var1) throws AuthException;
}

