/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.model;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.ModelTask;
import org.apache.iotdb.common.rpc.thrift.TrainingState;
import org.apache.iotdb.commons.model.ModelHyperparameter;
import org.apache.iotdb.commons.model.TrailInformation;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ModelInformation {
    private final String modelId;
    private final ModelTask modelTask;
    private final String modelType;
    private final List<String> queryExpressions;
    @Nullable
    private String queryFilter;
    private final boolean isAuto;
    private TrainingState trainingState;
    @Nullable
    private String bestTrailId;
    private final Map<String, TrailInformation> trailMap;

    public ModelInformation(String modelId, ModelTask modelTask, String modelType, boolean isAuto, List<String> queryExpressions, @Nullable String queryFilter) {
        this.modelId = modelId;
        this.modelTask = modelTask;
        this.modelType = modelType;
        this.isAuto = isAuto;
        this.trainingState = TrainingState.PENDING;
        this.queryExpressions = queryExpressions;
        this.queryFilter = queryFilter;
        this.trailMap = new HashMap<String, TrailInformation>();
    }

    public ModelInformation(ByteBuffer buffer) {
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.modelTask = ModelTask.findByValue((int)ReadWriteIOUtils.readInt((ByteBuffer)buffer));
        this.modelType = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.queryExpressions = new ArrayList<String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            this.queryExpressions.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        if (isNull == 1) {
            this.queryFilter = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        this.isAuto = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.trainingState = TrainingState.findByValue((int)ReadWriteIOUtils.readInt((ByteBuffer)buffer));
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        if (isNull == 1) {
            this.bestTrailId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        int mapSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.trailMap = new HashMap<String, TrailInformation>();
        for (int i = 0; i < mapSize; ++i) {
            TrailInformation trailInformation = TrailInformation.deserialize(buffer);
            this.trailMap.put(trailInformation.getTrailId(), trailInformation);
        }
    }

    public ModelInformation(InputStream stream) throws IOException {
        this.modelId = ReadWriteIOUtils.readString((InputStream)stream);
        this.modelTask = ModelTask.findByValue((int)ReadWriteIOUtils.readInt((InputStream)stream));
        this.modelType = ReadWriteIOUtils.readString((InputStream)stream);
        int listSize = ReadWriteIOUtils.readInt((InputStream)stream);
        this.queryExpressions = new ArrayList<String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            this.queryExpressions.add(ReadWriteIOUtils.readString((InputStream)stream));
        }
        byte isNull = ReadWriteIOUtils.readByte((InputStream)stream);
        if (isNull == 1) {
            this.queryFilter = ReadWriteIOUtils.readString((InputStream)stream);
        }
        this.isAuto = ReadWriteIOUtils.readBool((InputStream)stream);
        this.trainingState = TrainingState.findByValue((int)ReadWriteIOUtils.readInt((InputStream)stream));
        isNull = ReadWriteIOUtils.readByte((InputStream)stream);
        if (isNull == 1) {
            this.bestTrailId = ReadWriteIOUtils.readString((InputStream)stream);
        }
        int mapSize = ReadWriteIOUtils.readInt((InputStream)stream);
        this.trailMap = new HashMap<String, TrailInformation>();
        for (int i = 0; i < mapSize; ++i) {
            TrailInformation trailInformation = TrailInformation.deserialize(stream);
            this.trailMap.put(trailInformation.getTrailId(), trailInformation);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public List<String> getQueryExpressions() {
        return this.queryExpressions;
    }

    @Nullable
    public String getQueryFilter() {
        return this.queryFilter;
    }

    public TrailInformation getTrailInformationById(String trailId) {
        if (this.trailMap.containsKey(trailId)) {
            return this.trailMap.get(trailId);
        }
        return null;
    }

    public List<TrailInformation> getAllTrailInformation() {
        return new ArrayList<TrailInformation>(this.trailMap.values());
    }

    public void update(String trailId, Map<String, String> modelInfo) {
        if (!this.trailMap.containsKey(trailId)) {
            String modelPath = null;
            if (modelInfo.containsKey("model_path")) {
                modelPath = modelInfo.get("model_path");
                modelInfo.remove("model_path");
            }
            TrailInformation trailInformation = new TrailInformation(trailId, new ModelHyperparameter(modelInfo), modelPath);
            this.trailMap.put(trailId, trailInformation);
        } else {
            this.trailMap.get(trailId).update(modelInfo);
        }
    }

    public void updateState(TrainingState newState, String bestTrailId) {
        this.trainingState = newState;
        if (bestTrailId != null) {
            this.bestTrailId = bestTrailId;
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.modelTask.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelType, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.queryExpressions.size(), (OutputStream)stream);
        for (String queryExpression : this.queryExpressions) {
            ReadWriteIOUtils.write((String)queryExpression, (OutputStream)stream);
        }
        if (this.queryFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.queryFilter, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isAuto, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.trainingState.ordinal(), (OutputStream)stream);
        if (this.bestTrailId == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.bestTrailId, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.trailMap.size(), (OutputStream)stream);
        for (TrailInformation trailInformation : this.trailMap.values()) {
            trailInformation.serialize(stream);
        }
    }

    public void serialize(FileOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.modelTask.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelType, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.queryExpressions.size(), (OutputStream)stream);
        for (String queryExpression : this.queryExpressions) {
            ReadWriteIOUtils.write((String)queryExpression, (OutputStream)stream);
        }
        if (this.queryFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.queryFilter, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isAuto, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.trainingState.ordinal(), (OutputStream)stream);
        if (this.bestTrailId == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.bestTrailId, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.trailMap.size(), (OutputStream)stream);
        for (TrailInformation trailInformation : this.trailMap.values()) {
            trailInformation.serialize(stream);
        }
    }

    public static ModelInformation deserialize(InputStream stream) throws IOException {
        return new ModelInformation(stream);
    }

    public static ModelInformation deserialize(ByteBuffer buffer) {
        return new ModelInformation(buffer);
    }

    public ByteBuffer serializeShowModelResult() throws IOException {
        PublicBAOS buffer = new PublicBAOS();
        DataOutputStream stream = new DataOutputStream((OutputStream)buffer);
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelTask.toString(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelType, (OutputStream)stream);
        ReadWriteIOUtils.write((String)Arrays.toString(this.queryExpressions.toArray(new String[0])), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.trainingState.toString(), (OutputStream)stream);
        if (this.bestTrailId != null) {
            TrailInformation bestTrail = this.trailMap.get(this.bestTrailId);
            ReadWriteIOUtils.write((String)bestTrail.getModelPath(), (OutputStream)stream);
            List<String> modelHyperparameterList = bestTrail.getModelHyperparameter().toStringList();
            ReadWriteIOUtils.write((int)modelHyperparameterList.size(), (OutputStream)stream);
            for (String hyperparameter : modelHyperparameterList) {
                ReadWriteIOUtils.write((String)hyperparameter, (OutputStream)stream);
            }
        } else {
            ReadWriteIOUtils.write((String)"UNKNOWN", (OutputStream)stream);
            ReadWriteIOUtils.write((int)1, (OutputStream)stream);
            ReadWriteIOUtils.write((String)"UNKNOWN", (OutputStream)stream);
        }
        return ByteBuffer.wrap(buffer.getBuf(), 0, buffer.size());
    }
}

