/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.match;

import java.util.Iterator;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.IPatternFA;
import org.apache.iotdb.commons.path.fa.match.IStateMatchInfo;
import org.apache.iotdb.commons.path.fa.match.MatchedStateSet;

public class StateMultiMatchInfo
implements IStateMatchInfo {
    private final IPatternFA patternFA;
    private final MatchedStateSet matchedStateSet;
    private int sourceStateIndex;
    private Iterator<IFATransition> sourceTransitionIterator;
    private boolean hasFinalState = false;

    public StateMultiMatchInfo(IPatternFA patternFA) {
        this.patternFA = patternFA;
        this.matchedStateSet = new MatchedStateSet(patternFA.getStateSize());
    }

    public StateMultiMatchInfo(IPatternFA patternFA, IFAState matchedState, Iterator<IFATransition> sourceTransitionIterator) {
        this.patternFA = patternFA;
        this.matchedStateSet = new MatchedStateSet(patternFA.getStateSize());
        this.matchedStateSet.add(matchedState);
        this.sourceStateIndex = 0;
        this.sourceTransitionIterator = sourceTransitionIterator;
        this.hasFinalState = matchedState.isFinal();
    }

    @Override
    public boolean hasFinalState() {
        return this.hasFinalState;
    }

    @Override
    public boolean hasOnlyPreciseMatchTransition() {
        return false;
    }

    @Override
    public boolean hasNoPreciseMatchTransition() {
        return false;
    }

    @Override
    public boolean isSingleFuzzyMatchTransition() {
        return false;
    }

    @Override
    public IFAState getOneMatchedState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMatchedState(IFAState state) {
        this.matchedStateSet.add(state);
        if (state.isFinal()) {
            this.hasFinalState = true;
        }
    }

    @Override
    public IFAState getMatchedState(int stateOrdinal) {
        return this.patternFA.getState(this.matchedStateSet.getStateIndex(stateOrdinal));
    }

    @Override
    public int getMatchedStateSize() {
        return this.matchedStateSet.size();
    }

    @Override
    public int getSourceStateOrdinal() {
        return this.sourceStateIndex;
    }

    @Override
    public void setSourceStateOrdinal(int sourceStateOrdinal) {
        this.sourceStateIndex = sourceStateOrdinal;
    }

    @Override
    public Iterator<IFATransition> getSourceTransitionIterator() {
        return this.sourceTransitionIterator;
    }

    @Override
    public void setSourceTransitionIterator(Iterator<IFATransition> sourceTransitionIterator) {
        this.sourceTransitionIterator = sourceTransitionIterator;
    }
}

