/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMetaKeeper;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConfigNodePipePluginMetaKeeper
extends PipePluginMetaKeeper {
    protected final Map<String, String> jarNameToMd5Map;
    protected final Map<String, Integer> jarNameToReferenceCountMap;

    public ConfigNodePipePluginMetaKeeper() {
        this.loadBuiltInPlugins();
        this.jarNameToMd5Map = new HashMap<String, String>();
        this.jarNameToReferenceCountMap = new HashMap<String, Integer>();
    }

    public synchronized boolean containsJar(String jarName) {
        return this.jarNameToMd5Map.containsKey(jarName);
    }

    public synchronized boolean jarNameExistsAndMatchesMd5(String jarName, String md5) {
        return this.jarNameToMd5Map.containsKey(jarName) && this.jarNameToMd5Map.get(jarName).equals(md5);
    }

    public synchronized void addJarNameAndMd5(String jarName, String md5) {
        if (this.jarNameToReferenceCountMap.containsKey(jarName)) {
            this.jarNameToReferenceCountMap.put(jarName, this.jarNameToReferenceCountMap.get(jarName) + 1);
        } else {
            this.jarNameToReferenceCountMap.put(jarName, 1);
            this.jarNameToMd5Map.put(jarName, md5);
        }
    }

    public synchronized void removeJarNameAndMd5IfPossible(String jarName) {
        if (this.jarNameToReferenceCountMap.containsKey(jarName)) {
            int count = this.jarNameToReferenceCountMap.get(jarName);
            if (count == 1) {
                this.jarNameToReferenceCountMap.remove(jarName);
                this.jarNameToMd5Map.remove(jarName);
            } else {
                this.jarNameToReferenceCountMap.put(jarName, count - 1);
            }
        }
    }

    @Override
    public void processTakeSnapshot(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.jarNameToMd5Map.size(), (OutputStream)outputStream);
        for (Map.Entry<String, String> entry : this.jarNameToMd5Map.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)this.jarNameToReferenceCountMap.get(entry.getKey()), (OutputStream)outputStream);
        }
        super.processTakeSnapshot(outputStream);
    }

    @Override
    public void processLoadSnapshot(InputStream inputStream) throws IOException {
        this.jarNameToMd5Map.clear();
        this.jarNameToReferenceCountMap.clear();
        int jarSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < jarSize; ++i) {
            String jarName = ReadWriteIOUtils.readString((InputStream)inputStream);
            String md5 = ReadWriteIOUtils.readString((InputStream)inputStream);
            int count = ReadWriteIOUtils.readInt((InputStream)inputStream);
            this.jarNameToMd5Map.put(jarName, md5);
            this.jarNameToReferenceCountMap.put(jarName, count);
        }
        super.processLoadSnapshot(inputStream);
    }
}

