/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.node.common;

import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.info.IDatabaseDeviceInfo;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;

public abstract class AbstractDatabaseDeviceMNode<N extends IMNode<N>, BasicNode extends IMNode<N>>
implements IDatabaseMNode<N>,
IDeviceMNode<N> {
    private final IDatabaseDeviceInfo<N> databaseDeviceInfo;
    protected final BasicNode basicMNode;

    public AbstractDatabaseDeviceMNode(BasicNode basicMNode, IDatabaseDeviceInfo<N> databaseDeviceInfo) {
        this.basicMNode = basicMNode;
        this.databaseDeviceInfo = databaseDeviceInfo;
    }

    public BasicNode getBasicMNode() {
        return this.basicMNode;
    }

    @Override
    public String getName() {
        return this.basicMNode.getName();
    }

    @Override
    public void setName(String name) {
        this.basicMNode.setName(name);
    }

    @Override
    public N getParent() {
        return this.basicMNode.getParent();
    }

    @Override
    public void setParent(N parent) {
        this.basicMNode.setParent(parent);
    }

    @Override
    public String getFullPath() {
        return this.basicMNode.getFullPath();
    }

    @Override
    public void setFullPath(String fullPath) {
        this.basicMNode.setFullPath(fullPath);
    }

    @Override
    public PartialPath getPartialPath() {
        return this.basicMNode.getPartialPath();
    }

    @Override
    public boolean hasChild(String name) {
        return this.basicMNode.hasChild(name);
    }

    @Override
    public N getChild(String name) {
        return this.basicMNode.getChild(name);
    }

    @Override
    public N addChild(String name, N child) {
        N res = this.basicMNode.addChild(name, child);
        if (res == child) {
            child.setParent(this.getAsMNode());
        }
        return res;
    }

    @Override
    public N addChild(N child) {
        N res = this.basicMNode.addChild(child);
        if (res == child) {
            child.setParent(this.getAsMNode());
        }
        return res;
    }

    @Override
    public N deleteChild(String name) {
        return this.basicMNode.deleteChild(name);
    }

    @Override
    public void replaceChild(String oldChildName, N newChildNode) {
        this.basicMNode.replaceChild(oldChildName, newChildNode);
    }

    @Override
    public void moveDataToNewMNode(N newMNode) {
        this.basicMNode.moveDataToNewMNode(newMNode);
        if (newMNode.isDevice()) {
            this.databaseDeviceInfo.moveDataToNewMNode(newMNode.getAsDeviceMNode());
        }
        if (newMNode.isDatabase()) {
            this.databaseDeviceInfo.moveDataToNewMNode(newMNode.getAsDatabaseMNode());
        }
    }

    @Override
    public IMNodeContainer<N> getChildren() {
        return this.basicMNode.getChildren();
    }

    @Override
    public void setChildren(IMNodeContainer<N> children) {
        this.basicMNode.setChildren(children);
    }

    @Override
    public boolean isAboveDatabase() {
        return false;
    }

    @Override
    public boolean isDatabase() {
        return true;
    }

    @Override
    public boolean isDevice() {
        return true;
    }

    @Override
    public boolean isMeasurement() {
        return false;
    }

    @Override
    public MNodeType getMNodeType(Boolean isConfig) {
        return MNodeType.STORAGE_GROUP;
    }

    @Override
    public IDatabaseMNode<N> getAsDatabaseMNode() {
        return this;
    }

    @Override
    public IDeviceMNode<N> getAsDeviceMNode() {
        return this;
    }

    @Override
    public IMeasurementMNode<N> getAsMeasurementMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitDatabaseDeviceMNode(this, context);
    }

    @Override
    public long getDataTTL() {
        return this.databaseDeviceInfo.getDataTTL();
    }

    @Override
    public void setDataTTL(long dataTTL) {
        this.databaseDeviceInfo.setDataTTL(dataTTL);
    }

    @Override
    public boolean addAlias(String alias, IMeasurementMNode<N> child) {
        return this.databaseDeviceInfo.addAlias(alias, child);
    }

    @Override
    public void deleteAliasChild(String alias) {
        this.databaseDeviceInfo.deleteAliasChild(alias);
    }

    @Override
    public Map<String, IMeasurementMNode<N>> getAliasChildren() {
        return this.databaseDeviceInfo.getAliasChildren();
    }

    @Override
    public void setAliasChildren(Map<String, IMeasurementMNode<N>> aliasChildren) {
        this.databaseDeviceInfo.setAliasChildren(aliasChildren);
    }

    @Override
    public boolean isUseTemplate() {
        return this.databaseDeviceInfo.isUseTemplate();
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.databaseDeviceInfo.setUseTemplate(useTemplate);
    }

    @Override
    public void setSchemaTemplateId(int schemaTemplateId) {
        this.databaseDeviceInfo.setSchemaTemplateId(schemaTemplateId);
    }

    @Override
    public int getSchemaTemplateId() {
        return this.databaseDeviceInfo.getSchemaTemplateId();
    }

    @Override
    public int getSchemaTemplateIdWithState() {
        return this.databaseDeviceInfo.getSchemaTemplateIdWithState();
    }

    @Override
    public boolean isPreDeactivateTemplate() {
        return this.databaseDeviceInfo.isPreDeactivateTemplate();
    }

    @Override
    public void preDeactivateTemplate() {
        this.databaseDeviceInfo.preDeactivateTemplate();
    }

    @Override
    public void rollbackPreDeactivateTemplate() {
        this.databaseDeviceInfo.rollbackPreDeactivateTemplate();
    }

    @Override
    public void deactivateTemplate() {
        this.databaseDeviceInfo.deactivateTemplate();
    }

    @Override
    public boolean isAligned() {
        Boolean align = this.databaseDeviceInfo.isAligned();
        if (align == null) {
            return false;
        }
        return align;
    }

    @Override
    public Boolean isAlignedNullable() {
        return this.databaseDeviceInfo.isAligned();
    }

    @Override
    public void setAligned(Boolean isAligned) {
        this.databaseDeviceInfo.setAligned(isAligned);
    }

    @Override
    public int estimateSize() {
        return 16 + this.databaseDeviceInfo.estimateSize() + this.basicMNode.estimateSize();
    }
}

