/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.unary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InViewExpression
extends UnaryViewExpression {
    private final boolean isNotIn;
    private final List<String> valueList;

    public InViewExpression(ViewExpression expression, boolean isNotIn, List<String> values) {
        super(expression);
        this.isNotIn = isNotIn;
        this.valueList = values;
    }

    public InViewExpression(ByteBuffer byteBuffer) {
        super(ViewExpression.deserialize(byteBuffer));
        this.isNotIn = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.valueList = ReadWriteIOUtils.readStringList((ByteBuffer)byteBuffer);
    }

    public InViewExpression(InputStream inputStream) {
        super(ViewExpression.deserialize(inputStream));
        try {
            this.isNotIn = ReadWriteIOUtils.readBool((InputStream)inputStream);
            this.valueList = ReadWriteIOUtils.readStringList((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.IN;
    }

    @Override
    public String toString(boolean isRoot) {
        return "IN " + this.expression.toString();
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNotIn, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.writeStringList(this.valueList, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNotIn, (OutputStream)stream);
        ReadWriteIOUtils.writeStringList(this.valueList, (OutputStream)stream);
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public LinkedHashSet<String> getValuesInLinkedHashSet() {
        return new LinkedHashSet<String>(this.valueList);
    }

    public List<String> getValueList() {
        return this.valueList;
    }
}

