/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service.metric;

import com.google.common.base.Preconditions;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.service.metric.GcTimeAlerter;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmGcMonitorMetrics
implements IMetricSet {
    public static final long OBSERVATION_WINDOW_MS = TimeUnit.MINUTES.toMillis(1L);
    public static final long SLEEP_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
    public static final long MAX_GC_TIME_PERCENTAGE = 40L;
    private static long startTime;
    private static final Logger logger;
    private final ScheduledExecutorService scheduledGCInfoMonitor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(ThreadName.JVM_GC_STATISTICS_MONITOR.getName());
    private Future<?> scheduledGcMonitorFuture;
    private final TsAndData[] gcDataBuf;
    private final int bufSize;
    private int startIdx;
    private int endIdx;
    private final GcData curData = new GcData();
    private final GcTimeAlertHandler alertHandler;

    public JvmGcMonitorMetrics() {
        this.bufSize = (int)(OBSERVATION_WINDOW_MS / SLEEP_INTERVAL_MS + 2L);
        Preconditions.checkArgument((this.bufSize <= 131072 ? 1 : 0) != 0);
        this.gcDataBuf = new TsAndData[this.bufSize];
        for (int i = 0; i < this.bufSize; ++i) {
            this.gcDataBuf[i] = new TsAndData();
        }
        this.alertHandler = new GcTimeAlerter();
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.JVM_GC_ACCUMULATED_TIME_PERCENTAGE.toString(), MetricLevel.CORE, (Object)this.curData, GcData::getGcTimePercentage, new String[0]);
        startTime = System.currentTimeMillis();
        this.gcDataBuf[this.startIdx].setValues(startTime + TimeUnit.MILLISECONDS.toMillis(50L), 0L);
        this.scheduledGcMonitorFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay(this.scheduledGCInfoMonitor, this::scheduledMonitoring, TimeUnit.MILLISECONDS.toMillis(50L), SLEEP_INTERVAL_MS, TimeUnit.MILLISECONDS);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_GC_ACCUMULATED_TIME_PERCENTAGE.toString(), new String[0]);
        if (this.scheduledGcMonitorFuture != null) {
            this.scheduledGcMonitorFuture.cancel(false);
            this.scheduledGcMonitorFuture = null;
            logger.info("JVM GC scheduled monitor is stopped successfully.");
        }
    }

    private void scheduledMonitoring() {
        this.calculateGCTimePercentageWithinObservedInterval();
        if (this.alertHandler != null && this.curData.gcTimePercentage.get() > 40L) {
            this.alertHandler.alert(this.curData.clone());
        }
    }

    private void calculateGCTimePercentageWithinObservedInterval() {
        long prevTotalGcTime = this.curData.getAccumulatedGcTime();
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += gcBean.getCollectionTime();
        }
        long gcTimeWithinSleepInterval = totalGcTime - prevTotalGcTime;
        long curTime = System.currentTimeMillis();
        long gcMonitorRunTime = curTime - startTime;
        this.endIdx = (this.endIdx + 1) % this.bufSize;
        this.gcDataBuf[this.endIdx].setValues(curTime, gcTimeWithinSleepInterval);
        long startObsWindowTs = curTime - OBSERVATION_WINDOW_MS;
        while (this.gcDataBuf[this.startIdx].ts < startObsWindowTs && this.startIdx != this.endIdx) {
            this.startIdx = (this.startIdx + 1) % this.bufSize;
        }
        long gcTimeWithinObservationWindow = Math.min(this.gcDataBuf[this.startIdx].gcPause, this.gcDataBuf[this.startIdx].ts - startObsWindowTs);
        if (this.startIdx != this.endIdx) {
            int i = (this.startIdx + 1) % this.bufSize;
            while (i != this.endIdx) {
                gcTimeWithinObservationWindow += this.gcDataBuf[i].gcPause;
                i = (i + 1) % this.bufSize;
            }
        }
        this.curData.update(curTime, startObsWindowTs, totalGcTime, gcTimeWithinObservationWindow, (int)(gcTimeWithinObservationWindow * 100L / Math.min(JvmGcMonitorMetrics.OBSERVATION_WINDOW_MS, gcMonitorRunTime)));
    }

    public static JvmGcMonitorMetrics getInstance() {
        return JvmGcMetricsHolder.INSTANCE;
    }

    static {
        logger = LoggerFactory.getLogger(JvmGcMonitorMetrics.class);
    }

    private static class JvmGcMetricsHolder {
        private static final JvmGcMonitorMetrics INSTANCE = new JvmGcMonitorMetrics();

        private JvmGcMetricsHolder() {
        }
    }

    public static interface GcTimeAlertHandler {
        public void alert(GcData var1);
    }

    private static class TsAndData {
        private long ts;
        private long gcPause;

        private TsAndData() {
        }

        void setValues(long inTs, long inGcPause) {
            this.ts = inTs;
            this.gcPause = inGcPause;
        }
    }

    public static class GcData
    implements Cloneable {
        private final AtomicLong timestamp = new AtomicLong();
        private final AtomicLong startObsWindowTs = new AtomicLong();
        private final AtomicLong accumulatedGcTime = new AtomicLong();
        private final AtomicLong gcTimePercentage = new AtomicLong();
        private final AtomicLong gcTimeWithinObsWindow = new AtomicLong();

        public long getCurrentObsWindowTs() {
            return Math.min(this.timestamp.get() - startTime, this.timestamp.get() - this.startObsWindowTs.get());
        }

        public long getTimestamp() {
            return this.timestamp.get();
        }

        public long getStartObsWindowTs() {
            return Math.max(this.startObsWindowTs.get(), startTime);
        }

        public long getAccumulatedGcTime() {
            return this.accumulatedGcTime.get();
        }

        public long getGcTimeWithinObsWindow() {
            return this.gcTimeWithinObsWindow.get();
        }

        public long getGcTimePercentage() {
            return this.gcTimePercentage.get();
        }

        private synchronized void update(long inTimestamp, long inStartObsWindowTs, long inTotalGcTime, long inGcTimeWithinObsWindow, int inGcTimePercentage) {
            this.timestamp.set(inTimestamp);
            this.startObsWindowTs.set(inStartObsWindowTs);
            this.accumulatedGcTime.set(inTotalGcTime);
            this.gcTimeWithinObsWindow.set(inGcTimeWithinObsWindow);
            this.gcTimePercentage.set(inGcTimePercentage);
        }

        public synchronized GcData clone() {
            try {
                return (GcData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

