/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFStrLocate
implements UDTF {
    private String target;
    private boolean reverse;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(target -> ((String)target).length() > 0, "target should not be empty", (Object)validator.getParameters().getString("target"));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.target = parameters.getString("target");
        this.reverse = parameters.getBooleanOrDefault("reverse", false);
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.INT32);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putInt(row.getTime(), this.reverse ? row.getString(0).lastIndexOf(this.target) : row.getString(0).indexOf(this.target));
    }
}

