/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;

public class KDTreeUtil {
    private Node kdTree;

    public static KDTreeUtil build(ArrayList<ArrayList<Double>> input, int dimension) {
        KDTreeUtil tree = new KDTreeUtil();
        tree.kdTree = new Node();
        tree.buildDetail(tree.kdTree, input, dimension);
        return tree;
    }

    private void buildDetail(Node node, ArrayList<ArrayList<Double>> data, int dimensions) {
        if (data.isEmpty()) {
            return;
        }
        if (data.size() == 1) {
            node.isLeaf = true;
            node.value = data.get(0);
            return;
        }
        node.partitionDimension = -1;
        double var = -1.0;
        for (int i = 0; i < dimensions; ++i) {
            double tmpvar = UtilZ.variance(data, i);
            if (!(tmpvar > var)) continue;
            var = tmpvar;
            node.partitionDimension = i;
        }
        if (var == 0.0) {
            node.isLeaf = true;
            node.value = data.get(0);
            return;
        }
        node.partitionValue = UtilZ.median(data, node.partitionDimension);
        ArrayList<ArrayList<Double>> maxMin = UtilZ.maxMin(data, dimensions);
        node.min = maxMin.get(0);
        node.max = maxMin.get(1);
        ArrayList<ArrayList<Double>> left = new ArrayList<ArrayList<Double>>();
        ArrayList<ArrayList<Double>> right = new ArrayList<ArrayList<Double>>();
        for (ArrayList<Double> d : data) {
            if (d.get(node.partitionDimension) < node.partitionValue) {
                left.add(d);
                continue;
            }
            if (!(d.get(node.partitionDimension) > node.partitionValue)) continue;
            right.add(d);
        }
        for (ArrayList<Double> d : data) {
            if (d.get(node.partitionDimension) != node.partitionValue) continue;
            if (left.isEmpty()) {
                left.add(d);
                continue;
            }
            right.add(d);
        }
        Node leftNode = new Node();
        Node rightNode = new Node();
        node.left = leftNode;
        node.right = rightNode;
        this.buildDetail(leftNode, left, dimensions);
        this.buildDetail(rightNode, right, dimensions);
    }

    public ArrayList<Double> query(ArrayList<Double> input, double[] std) {
        Node node = this.kdTree;
        Stack<Node> stack = new Stack<Node>();
        while (!node.isLeaf) {
            if (input.get(node.partitionDimension) < node.partitionValue) {
                stack.add(node.right);
                node = node.left;
                continue;
            }
            stack.push(node.left);
            node = node.right;
        }
        double distance = UtilZ.distance(input, node.value, std);
        ArrayList<Double> nearest = this.queryRec(input, distance, stack, std);
        return nearest == null ? node.value : nearest;
    }

    public ArrayList<Double> queryRec(ArrayList<Double> input, double distance, Stack<Node> stack, double[] std) {
        ArrayList<Double> nearest = null;
        while (!stack.isEmpty()) {
            double tdis;
            Node node = stack.pop();
            if (node.isLeaf) {
                tdis = UtilZ.distance(input, node.value, std);
                if (!(tdis < distance)) continue;
                distance = tdis;
                nearest = node.value;
                continue;
            }
            double minDistance = UtilZ.minDistance(input, node.max, node.min, std);
            if (!(minDistance < distance)) continue;
            while (!node.isLeaf) {
                if (input.get(node.partitionDimension) < node.partitionValue) {
                    stack.add(node.right);
                    node = node.left;
                    continue;
                }
                stack.push(node.left);
                node = node.right;
            }
            tdis = UtilZ.distance(input, node.value, std);
            if (!(tdis < distance)) continue;
            distance = tdis;
            nearest = node.value;
        }
        return nearest;
    }

    public ArrayList<ArrayList<Double>> queryRecKNN(ArrayList<Double> input, double distance, Stack<Node> stack, double[] std) {
        ArrayList<ArrayList<Double>> nearest = new ArrayList<ArrayList<Double>>();
        while (!stack.isEmpty()) {
            double tdis;
            Node node = stack.pop();
            if (node.isLeaf) {
                tdis = UtilZ.distance(input, node.value, std);
                if (!(tdis < distance)) continue;
                distance = tdis;
                nearest.add(node.value);
                continue;
            }
            double minDistance = UtilZ.minDistance(input, node.max, node.min, std);
            if (!(minDistance < distance)) continue;
            while (!node.isLeaf) {
                if (input.get(node.partitionDimension) < node.partitionValue) {
                    stack.add(node.right);
                    node = node.left;
                    continue;
                }
                stack.push(node.left);
                node = node.right;
            }
            tdis = UtilZ.distance(input, node.value, std);
            if (!(tdis < distance)) continue;
            distance = tdis;
            nearest.add(node.value);
        }
        return nearest;
    }

    public ArrayList<Double> findNearest(ArrayList<Double> input, ArrayList<ArrayList<Double>> nearest, double[] std) {
        double min_dis = Double.MAX_VALUE;
        int min_index = 0;
        for (int i = 0; i < nearest.size(); ++i) {
            double dis = UtilZ.distance(input, nearest.get(i), std);
            if (!(dis < min_dis)) continue;
            min_dis = dis;
            min_index = i;
        }
        ArrayList<Double> nt = nearest.get(min_index);
        nearest.remove(min_index);
        return nt;
    }

    public ArrayList<ArrayList<Double>> queryKNN(ArrayList<Double> input, int k, double[] std) {
        ArrayList<ArrayList<Double>> kNearest = new ArrayList<ArrayList<Double>>();
        Node node = this.kdTree;
        Stack<Node> stack = new Stack<Node>();
        while (!node.isLeaf) {
            if (input.get(node.partitionDimension) < node.partitionValue) {
                stack.add(node.right);
                node = node.left;
                continue;
            }
            stack.push(node.left);
            node = node.right;
        }
        double distance = UtilZ.distance(input, node.value, std);
        ArrayList<ArrayList<Double>> nearest = this.queryRecKNN(input, distance, stack, std);
        for (int i = 0; i < Math.min(k, nearest.size()); ++i) {
            kNearest.add(this.findNearest(input, nearest, std));
        }
        if (kNearest.isEmpty()) {
            kNearest.add(node.value);
        }
        for (ArrayList arrayList : kNearest) {
            UtilZ.distance(arrayList, input, std);
        }
        return kNearest;
    }

    private static class UtilZ {
        private UtilZ() {
        }

        static double variance(ArrayList<ArrayList<Double>> data, int dimension) {
            double sum = 0.0;
            for (ArrayList<Double> d : data) {
                sum += d.get(dimension).doubleValue();
            }
            double avg = sum / (double)data.size();
            double ans = 0.0;
            for (ArrayList<Double> d : data) {
                double temp = d.get(dimension) - avg;
                ans += temp * temp;
            }
            return ans / (double)data.size();
        }

        static double median(ArrayList<ArrayList<Double>> data, int dimension) {
            ArrayList<Double> d = new ArrayList<Double>();
            for (ArrayList<Double> k : data) {
                d.add(k.get(dimension));
            }
            Collections.sort(d);
            int pos = d.size() / 2;
            return (Double)d.get(pos);
        }

        static ArrayList<ArrayList<Double>> maxMin(ArrayList<ArrayList<Double>> data, int dimensions) {
            ArrayList<ArrayList<Double>> mm = new ArrayList<ArrayList<Double>>();
            ArrayList<Double> min_v = new ArrayList<Double>();
            ArrayList<Double> max_v = new ArrayList<Double>();
            for (int i = 0; i < dimensions; ++i) {
                double min_temp = Double.MAX_VALUE;
                double max_temp = Double.MIN_VALUE;
                for (int j = 1; j < data.size(); ++j) {
                    ArrayList<Double> d = data.get(j);
                    if (d.get(i) < min_temp) {
                        min_temp = d.get(i);
                        continue;
                    }
                    if (!(d.get(i) > max_temp)) continue;
                    max_temp = d.get(i);
                }
                min_v.add(min_temp);
                max_v.add(max_temp);
            }
            mm.add(min_v);
            mm.add(max_v);
            return mm;
        }

        static double distance(ArrayList<Double> a, ArrayList<Double> b, double[] std) {
            double sum = 0.0;
            for (int i = 0; i < a.size(); ++i) {
                if (a.get(i) == null || b.get(i) == null) continue;
                sum += Math.pow((a.get(i) - b.get(i)) / std[i], 2.0);
            }
            sum = Math.sqrt(sum);
            return sum;
        }

        static double minDistance(ArrayList<Double> a, ArrayList<Double> max, ArrayList<Double> min, double[] std) {
            double sum = 0.0;
            for (int i = 0; i < a.size(); ++i) {
                if (a.get(i) > max.get(i)) {
                    sum += Math.pow((a.get(i) - max.get(i)) / std[i], 2.0);
                    continue;
                }
                if (!(a.get(i) < min.get(i))) continue;
                sum += Math.pow((min.get(i) - a.get(i)) / std[i], 2.0);
            }
            sum = Math.sqrt(sum);
            return sum;
        }
    }

    private static class Node {
        int partitionDimension;
        double partitionValue;
        ArrayList<Double> value;
        boolean isLeaf = false;
        Node left;
        Node right;
        ArrayList<Double> min;
        ArrayList<Double> max;

        private Node() {
        }
    }
}

