/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.SynchronizedHandler;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;

public class RpcUtils {
    public static final int THRIFT_DEFAULT_BUF_CAPACITY = 1024;
    public static final int THRIFT_FRAME_MAX_SIZE = 0x20000000;
    public static final int MAX_BUFFER_OVERSIZE_TIME = 5;
    public static final long MIN_SHRINK_INTERVAL = 60000L;
    public static final TSStatus SUCCESS_STATUS = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    public static final String DEFAULT_TIME_FORMAT = "default";
    public static final String DEFAULT_TIMESTAMP_PRECISION = "ms";

    private RpcUtils() {
    }

    public static IClientRPCService.Iface newSynchronizedClient(IClientRPCService.Iface client) {
        return (IClientRPCService.Iface)Proxy.newProxyInstance(RpcUtils.class.getClassLoader(), new Class[]{IClientRPCService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    public static void verifySuccess(TSStatus status) throws StatementExecutionException {
        if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            RpcUtils.verifySuccess(status.getSubStatus());
            return;
        }
        if (status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            return;
        }
        if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new StatementExecutionException(status);
        }
    }

    public static void verifySuccessWithRedirection(TSStatus status) throws StatementExecutionException, RedirectException {
        RpcUtils.verifySuccess(status);
        if (status.isSetRedirectNode()) {
            throw new RedirectException(status.getRedirectNode());
        }
    }

    public static void verifySuccessWithRedirectionForMultiDevices(TSStatus status, List<String> devices) throws StatementExecutionException, RedirectException {
        RpcUtils.verifySuccess(status);
        if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            HashMap<String, TEndPoint> deviceEndPointMap = new HashMap<String, TEndPoint>();
            List statusSubStatus = status.getSubStatus();
            for (int i = 0; i < statusSubStatus.size(); ++i) {
                TSStatus subStatus = (TSStatus)statusSubStatus.get(i);
                if (!subStatus.isSetRedirectNode()) continue;
                deviceEndPointMap.put(devices.get(i), subStatus.getRedirectNode());
            }
            throw new RedirectException(deviceEndPointMap);
        }
    }

    public static void verifySuccess(List<TSStatus> statuses) throws BatchExecutionException {
        StringBuilder errMsgs = new StringBuilder().append(TSStatusCode.MULTIPLE_ERROR.getStatusCode()).append(": ");
        for (TSStatus status : statuses) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
            errMsgs.append(status.getMessage()).append("; ");
        }
        if (errMsgs.length() > 0) {
            throw new BatchExecutionException(statuses, errMsgs.toString());
        }
    }

    public static TSStatus getStatus(TSStatusCode tsStatusCode) {
        return new TSStatus(tsStatusCode.getStatusCode());
    }

    public static TSStatus getStatus(List<TSStatus> statusList) {
        TSStatus status = new TSStatus(TSStatusCode.MULTIPLE_ERROR.getStatusCode());
        status.setSubStatus(statusList);
        return status;
    }

    public static TSStatus getStatus(TSStatusCode tsStatusCode, String message) {
        TSStatus status = new TSStatus(tsStatusCode.getStatusCode());
        status.setMessage(message);
        return status;
    }

    public static TSStatus getStatus(int code, String message) {
        TSStatus status = new TSStatus(code);
        status.setMessage(message);
        return status;
    }

    public static TSExecuteStatementResp getTSExecuteStatementResp(TSStatusCode tsStatusCode) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode);
        return RpcUtils.getTSExecuteStatementResp(status);
    }

    public static TSExecuteStatementResp getTSExecuteStatementResp(TSStatusCode tsStatusCode, String message) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode, message);
        return RpcUtils.getTSExecuteStatementResp(status);
    }

    public static TSExecuteStatementResp getTSExecuteStatementResp(TSStatus status) {
        TSExecuteStatementResp resp = new TSExecuteStatementResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        return resp;
    }

    public static TSFetchResultsResp getTSFetchResultsResp(TSStatusCode tsStatusCode) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode);
        return RpcUtils.getTSFetchResultsResp(status);
    }

    public static TSFetchResultsResp getTSFetchResultsResp(TSStatusCode tsStatusCode, String appendMessage) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode, appendMessage);
        return RpcUtils.getTSFetchResultsResp(status);
    }

    public static TSFetchResultsResp getTSFetchResultsResp(TSStatus status) {
        TSFetchResultsResp resp = new TSFetchResultsResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        return resp;
    }

    public static String setTimeFormat(String newTimeFormat) {
        String timeFormat;
        switch (newTimeFormat.trim().toLowerCase()) {
            case "long": 
            case "number": 
            case "default": 
            case "iso8601": {
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            default: {
                new SimpleDateFormat(newTimeFormat.trim());
                timeFormat = newTimeFormat;
            }
        }
        return timeFormat;
    }

    public static String formatDatetime(String timeFormat, String timePrecision, long timestamp, ZoneId zoneId) {
        switch (timeFormat) {
            case "long": 
            case "number": {
                return Long.toString(timestamp);
            }
            case "default": 
            case "iso8601": {
                return RpcUtils.parseLongToDateWithPrecision(DateTimeFormatter.ISO_OFFSET_DATE_TIME, timestamp, zoneId, timePrecision);
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return dateTime.format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static String formatDatetimeStr(String datetime, StringBuilder digits) {
        if (datetime.contains("+")) {
            String timeZoneStr = datetime.substring(datetime.length() - 6);
            return datetime.substring(0, datetime.length() - 6) + "." + digits + timeZoneStr;
        }
        if (datetime.contains("Z")) {
            String timeZoneStr = datetime.substring(datetime.length() - 1);
            return datetime.substring(0, datetime.length() - 1) + "." + digits + timeZoneStr;
        }
        String timeZoneStr = "";
        return datetime + "." + digits + timeZoneStr;
    }

    public static String parseLongToDateWithPrecision(DateTimeFormatter formatter, long timestamp, ZoneId zoneid, String timestampPrecision) {
        if (DEFAULT_TIMESTAMP_PRECISION.equals(timestampPrecision)) {
            long integerOfDate = timestamp / 1000L;
            StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000L));
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerOfDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 3) {
                for (int i = 0; i < 3 - length; ++i) {
                    digits.insert(0, "0");
                }
            }
            return RpcUtils.formatDatetimeStr(datetime, digits);
        }
        if ("us".equals(timestampPrecision)) {
            long integerOfDate = timestamp / 1000000L;
            StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000000L));
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerOfDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 6) {
                for (int i = 0; i < 6 - length; ++i) {
                    digits.insert(0, "0");
                }
            }
            return RpcUtils.formatDatetimeStr(datetime, digits);
        }
        long integerOfDate = timestamp / 1000000000L;
        StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000000000L));
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerOfDate), zoneid);
        String datetime = dateTime.format(formatter);
        int length = digits.length();
        if (length != 9) {
            for (int i = 0; i < 9 - length; ++i) {
                digits.insert(0, "0");
            }
        }
        return RpcUtils.formatDatetimeStr(datetime, digits);
    }

    public static TSStatus squashResponseStatusList(List<TSStatus> responseStatusList) {
        List failedStatus = responseStatusList.stream().filter(status -> status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).collect(Collectors.toList());
        return failedStatus.isEmpty() ? new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()) : new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(failedStatus.toString());
    }
}

